/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.worldcomment.io.lettuce.core.cluster.topology;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.RedisURI;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.cluster.topology.TimedAsyncCommand;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.cluster.topology.TopologyComparators;

class Requests {
    private final Map<RedisURI, TimedAsyncCommand<String, String, String>> rawViews;

    protected Requests() {
        this.rawViews = new TreeMap<RedisURI, TimedAsyncCommand<String, String, String>>(TopologyComparators.RedisURIComparator.INSTANCE);
    }

    private Requests(Map<RedisURI, TimedAsyncCommand<String, String, String>> rawViews) {
        this.rawViews = rawViews;
    }

    protected void addRequest(RedisURI redisURI, TimedAsyncCommand<String, String, String> command) {
        this.rawViews.put(redisURI, command);
    }

    public CompletableFuture<Void> allCompleted() {
        return CompletableFuture.allOf((CompletableFuture[])this.rawViews.values().stream().map(it -> it.exceptionally(throwable -> "ignore")).toArray(CompletableFuture[]::new));
    }

    protected Set<RedisURI> nodes() {
        return this.rawViews.keySet();
    }

    protected TimedAsyncCommand<String, String, String> getRequest(RedisURI redisURI) {
        return this.rawViews.get(redisURI);
    }

    protected Requests mergeWith(Requests requests) {
        TreeMap<RedisURI, TimedAsyncCommand<String, String, String>> result = new TreeMap<RedisURI, TimedAsyncCommand<String, String, String>>(TopologyComparators.RedisURIComparator.INSTANCE);
        result.putAll(this.rawViews);
        result.putAll(requests.rawViews);
        return new Requests(result);
    }
}

