/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.worldcomment.io.lettuce.core.codec;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.codec.ByteBufferInputStream;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.codec.RedisCodec;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.internal.LettuceAssert;

public abstract class CompressionCodec {
    private CompressionCodec() {
    }

    public static <K, V> RedisCodec<K, V> valueCompressor(RedisCodec<K, V> delegate, CompressionType compressionType) {
        LettuceAssert.notNull(delegate, "RedisCodec must not be null");
        LettuceAssert.notNull((Object)compressionType, "CompressionType must not be null");
        return new CompressingValueCodecWrapper(delegate, compressionType);
    }

    private static long copy(InputStream from, OutputStream to) throws IOException {
        int r;
        LettuceAssert.notNull((Object)from, "From must not be null");
        LettuceAssert.notNull((Object)to, "From must not be null");
        byte[] buf = new byte[4096];
        long total = 0L;
        while ((r = from.read(buf)) != -1) {
            to.write(buf, 0, r);
            total += (long)r;
        }
        return total;
    }

    public static enum CompressionType {
        GZIP,
        DEFLATE;

    }

    private static class CompressingValueCodecWrapper
    implements RedisCodec<Object, Object> {
        private RedisCodec<Object, Object> delegate;
        private CompressionType compressionType;

        public CompressingValueCodecWrapper(RedisCodec<Object, Object> delegate, CompressionType compressionType) {
            this.delegate = delegate;
            this.compressionType = compressionType;
        }

        @Override
        public Object decodeKey(ByteBuffer bytes) {
            return this.delegate.decodeKey(bytes);
        }

        @Override
        public Object decodeValue(ByteBuffer bytes) {
            try {
                return this.delegate.decodeValue(this.decompress(bytes));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public ByteBuffer encodeKey(Object key) {
            return this.delegate.encodeKey(key);
        }

        @Override
        public ByteBuffer encodeValue(Object value) {
            try {
                return this.compress(this.delegate.encodeValue(value));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ByteBuffer compress(ByteBuffer source) throws IOException {
            if (source.remaining() == 0) {
                return source;
            }
            OutputStream compressor = null;
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream(source.remaining() / 2);){
                try (ByteBufferInputStream sourceStream = new ByteBufferInputStream(source);){
                    if (this.compressionType == CompressionType.GZIP) {
                        compressor = new GZIPOutputStream(outputStream);
                    }
                    if (this.compressionType == CompressionType.DEFLATE) {
                        compressor = new DeflaterOutputStream(outputStream);
                    }
                    CompressionCodec.copy(sourceStream, compressor);
                }
                finally {
                    if (compressor != null) {
                        compressor.close();
                    }
                }
                ByteBuffer byteBuffer = ByteBuffer.wrap(outputStream.toByteArray());
                return byteBuffer;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ByteBuffer decompress(ByteBuffer source) throws IOException {
            if (source.remaining() == 0) {
                return source;
            }
            InputStream decompressor = null;
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream(source.remaining() * 2);){
                try (ByteBufferInputStream sourceStream = new ByteBufferInputStream(source);){
                    if (this.compressionType == CompressionType.GZIP) {
                        decompressor = new GZIPInputStream(sourceStream);
                    }
                    if (this.compressionType == CompressionType.DEFLATE) {
                        decompressor = new InflaterInputStream(sourceStream);
                    }
                    CompressionCodec.copy(decompressor, outputStream);
                }
                finally {
                    if (decompressor != null) {
                        decompressor.close();
                    }
                }
                ByteBuffer byteBuffer = ByteBuffer.wrap(outputStream.toByteArray());
                return byteBuffer;
            }
        }
    }
}

