/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.worldcomment.io.lettuce.core.dynamic;

import java.util.List;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.api.StatefulConnection;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.codec.RedisCodec;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.dynamic.AsyncExecutableCommand;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.dynamic.CommandFactory;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.dynamic.CommandMethod;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.dynamic.CommandMethodVerifier;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.dynamic.ExecutableCommand;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.dynamic.ExecutableCommandLookupStrategySupport;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.dynamic.RedisCommandsMetadata;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.dynamic.output.CommandOutputFactoryResolver;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.internal.LettuceAssert;

class AsyncExecutableCommandLookupStrategy
extends ExecutableCommandLookupStrategySupport {
    private final StatefulConnection<Object, Object> connection;

    public AsyncExecutableCommandLookupStrategy(List<RedisCodec<?, ?>> redisCodecs, CommandOutputFactoryResolver commandOutputFactoryResolver, CommandMethodVerifier commandMethodVerifier, StatefulConnection<Object, Object> connection) {
        super(redisCodecs, commandOutputFactoryResolver, commandMethodVerifier);
        this.connection = connection;
    }

    @Override
    public ExecutableCommand resolveCommandMethod(CommandMethod method, RedisCommandsMetadata metadata) {
        LettuceAssert.isTrue(!method.isReactiveExecution(), () -> String.format("Command method %s not supported by this command lookup strategy", method));
        CommandFactory commandFactory = super.resolveCommandFactory(method, metadata);
        return new AsyncExecutableCommand(method, commandFactory, this.connection);
    }
}

