/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.worldcomment.io.lettuce.core.dynamic;

import java.util.List;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.codec.RedisCodec;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.dynamic.CommandCreationException;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.dynamic.CommandFactory;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.dynamic.CommandFactoryResolver;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.dynamic.CommandMethod;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.dynamic.CommandMethodVerifier;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.dynamic.CommandSegmentCommandFactory;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.dynamic.ExecutableCommandLookupStrategy;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.dynamic.RedisCommandsMetadata;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.dynamic.codec.AnnotationRedisCodecResolver;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.dynamic.output.CodecAwareOutputFactoryResolver;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.dynamic.output.CommandOutputFactoryResolver;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.dynamic.segment.AnnotationCommandSegmentFactory;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.dynamic.segment.CommandSegments;

abstract class ExecutableCommandLookupStrategySupport
implements ExecutableCommandLookupStrategy {
    private final List<RedisCodec<?, ?>> redisCodecs;
    private final CommandOutputFactoryResolver commandOutputFactoryResolver;
    private final CommandFactoryResolver commandFactoryResolver;
    private final CommandMethodVerifier commandMethodVerifier;

    public ExecutableCommandLookupStrategySupport(List<RedisCodec<?, ?>> redisCodecs, CommandOutputFactoryResolver commandOutputFactoryResolver, CommandMethodVerifier commandMethodVerifier) {
        this.redisCodecs = redisCodecs;
        this.commandOutputFactoryResolver = commandOutputFactoryResolver;
        this.commandMethodVerifier = commandMethodVerifier;
        this.commandFactoryResolver = new DefaultCommandFactoryResolver();
    }

    protected CommandFactory resolveCommandFactory(CommandMethod commandMethod, RedisCommandsMetadata commandsMetadata) {
        return this.commandFactoryResolver.resolveRedisCommandFactory(commandMethod, commandsMetadata);
    }

    class DefaultCommandFactoryResolver
    implements CommandFactoryResolver {
        final AnnotationCommandSegmentFactory commandSegmentFactory = new AnnotationCommandSegmentFactory();
        final AnnotationRedisCodecResolver codecResolver;

        DefaultCommandFactoryResolver() {
            this.codecResolver = new AnnotationRedisCodecResolver(ExecutableCommandLookupStrategySupport.this.redisCodecs);
        }

        @Override
        public CommandFactory resolveRedisCommandFactory(CommandMethod commandMethod, RedisCommandsMetadata commandsMetadata) {
            RedisCodec<?, ?> codec = this.codecResolver.resolve(commandMethod);
            if (codec == null) {
                throw new CommandCreationException(commandMethod, "Cannot resolve RedisCodec");
            }
            CodecAwareOutputFactoryResolver outputFactoryResolver = new CodecAwareOutputFactoryResolver(ExecutableCommandLookupStrategySupport.this.commandOutputFactoryResolver, codec);
            CommandSegments commandSegments = this.commandSegmentFactory.createCommandSegments(commandMethod);
            ExecutableCommandLookupStrategySupport.this.commandMethodVerifier.validate(commandSegments, commandMethod);
            return new CommandSegmentCommandFactory(commandSegments, commandMethod, codec, outputFactoryResolver);
        }
    }
}

