/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.worldcomment.io.lettuce.core.dynamic;

import vendor.cn.zbx1425.worldcomment.io.lettuce.core.codec.RedisCodec;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.dynamic.CommandCreationException;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.dynamic.CommandMethod;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.dynamic.CommandSegmentCommandFactory;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.dynamic.ReactiveTypes;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.dynamic.output.CommandOutputFactory;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.dynamic.output.CommandOutputFactoryResolver;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.dynamic.output.OutputSelector;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.dynamic.parameter.ExecutionSpecificParameters;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.dynamic.segment.CommandSegments;

class ReactiveCommandSegmentCommandFactory
extends CommandSegmentCommandFactory {
    private boolean streamingExecution;

    ReactiveCommandSegmentCommandFactory(CommandSegments commandSegments, CommandMethod commandMethod, RedisCodec<?, ?> redisCodec, CommandOutputFactoryResolver outputResolver) {
        super(commandSegments, commandMethod, redisCodec, outputResolver);
        ExecutionSpecificParameters executionAwareParameters;
        if (commandMethod.getParameters() instanceof ExecutionSpecificParameters && (executionAwareParameters = (ExecutionSpecificParameters)commandMethod.getParameters()).hasTimeoutIndex()) {
            throw new CommandCreationException(commandMethod, "Reactive command methods do not support Timeout parameters");
        }
    }

    @Override
    protected CommandOutputFactory resolveCommandOutputFactory(OutputSelector outputSelector) {
        this.streamingExecution = ReactiveTypes.isMultiValueType(outputSelector.getOutputType().getRawClass());
        OutputSelector componentType = new OutputSelector(outputSelector.getOutputType().getGeneric(0), outputSelector.getRedisCodec());
        if (this.streamingExecution) {
            CommandOutputFactory streamingFactory = this.getOutputResolver().resolveStreamingCommandOutput(componentType);
            if (this.streamingExecution && streamingFactory != null) {
                return streamingFactory;
            }
        }
        return super.resolveCommandOutputFactory(componentType);
    }

    boolean isStreamingExecution() {
        return this.streamingExecution;
    }
}

