/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.worldcomment.io.lettuce.core.dynamic.intercept;

import java.lang.reflect.Method;
import java.util.Iterator;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.dynamic.intercept.InvocationTargetProvider;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.dynamic.intercept.MethodInterceptor;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.dynamic.intercept.MethodInvocation;

abstract class MethodInterceptorChain {
    private final ThreadLocal<PooledMethodInvocation> pool = ThreadLocal.withInitial(PooledMethodInvocation::new);
    final MethodInterceptorChain next;

    MethodInterceptorChain(MethodInterceptorChain next) {
        this.next = next;
    }

    public static Head from(Iterable<? extends MethodInterceptor> interceptors) {
        return new Head(MethodInterceptorChain.next(interceptors.iterator()));
    }

    private static MethodInterceptorChain next(Iterator<? extends MethodInterceptor> iterator) {
        return iterator.hasNext() ? MethodInterceptorChain.createContext(iterator, iterator.next()) : Tail.INSTANCE;
    }

    private static MethodInterceptorChain createContext(Iterator<? extends MethodInterceptor> iterator, MethodInterceptor interceptor) {
        return new MethodInterceptorContext(MethodInterceptorChain.next(iterator), interceptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object target, Method method, Object[] args) throws Throwable {
        PooledMethodInvocation invocation = this.getInvocation(target, method, args, this.next);
        try {
            if (this.next instanceof MethodInterceptorContext) {
                Object object = this.next.proceed(invocation);
                return object;
            }
            Object object = this.next.proceed(invocation);
            return object;
        }
        finally {
            invocation.clear();
        }
    }

    private PooledMethodInvocation getInvocation(Object target, Method method, Object[] args, MethodInterceptorChain next) {
        PooledMethodInvocation pooledMethodInvocation = this.pool.get();
        pooledMethodInvocation.initialize(target, method, args, next);
        return pooledMethodInvocation;
    }

    abstract Object proceed(MethodInvocation var1) throws Throwable;

    static class PooledMethodInvocation
    implements MethodInvocation,
    InvocationTargetProvider {
        private Object target;
        private Method method;
        private Object[] args;
        private MethodInterceptorChain current;

        PooledMethodInvocation() {
        }

        public void initialize(Object target, Method method, Object[] args, MethodInterceptorChain head) {
            this.target = target;
            this.method = method;
            this.args = args;
            this.current = head;
        }

        public void clear() {
            this.target = null;
            this.method = null;
            this.args = null;
            this.current = null;
        }

        @Override
        public Object proceed() throws Throwable {
            this.current = this.current.next;
            return this.current.proceed(this);
        }

        @Override
        public Object getInvocationTarget() {
            return this.target;
        }

        @Override
        public Method getMethod() {
            return this.method;
        }

        @Override
        public Object[] getArguments() {
            return this.args;
        }
    }

    static class Tail
    extends MethodInterceptorChain {
        public static Tail INSTANCE = new Tail();

        private Tail() {
            super(null);
        }

        @Override
        Object proceed(MethodInvocation invocation) throws Throwable {
            return null;
        }
    }

    static class Head
    extends MethodInterceptorChain {
        protected Head(MethodInterceptorChain next) {
            super(next);
        }

        @Override
        Object proceed(MethodInvocation invocation) throws Throwable {
            return this.next.proceed(invocation);
        }
    }

    static class MethodInterceptorContext
    extends MethodInterceptorChain {
        private final MethodInterceptor interceptor;

        MethodInterceptorContext(MethodInterceptorChain next, MethodInterceptor interceptor) {
            super(next);
            this.interceptor = interceptor;
        }

        @Override
        Object proceed(MethodInvocation invocation) throws Throwable {
            return this.interceptor.invoke(invocation);
        }
    }
}

