/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.worldcomment.io.lettuce.core.dynamic.parameter;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.dynamic.batch.CommandBatching;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.dynamic.domain.Timeout;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.dynamic.parameter.Parameter;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.dynamic.parameter.Parameters;

public class ExecutionSpecificParameters
extends Parameters<ExecutionAwareParameter> {
    private static final List<Class<?>> TYPES = Arrays.asList(Timeout.class, CommandBatching.class);
    private final int timeoutIndex;
    private final int commandBatchingIndex;

    public ExecutionSpecificParameters(Method method) {
        super(method);
        int timeoutIndex = -1;
        int commandBatchingIndex = -1;
        List parameters = this.getParameters();
        for (int i = 0; i < method.getParameterCount(); ++i) {
            Parameter methodParameter = (Parameter)parameters.get(i);
            if (!methodParameter.isSpecialParameter()) continue;
            if (methodParameter.isAssignableTo(Timeout.class)) {
                timeoutIndex = i;
            }
            if (!methodParameter.isAssignableTo(CommandBatching.class)) continue;
            commandBatchingIndex = i;
        }
        this.timeoutIndex = timeoutIndex;
        this.commandBatchingIndex = commandBatchingIndex;
    }

    public int getTimeoutIndex() {
        return this.timeoutIndex;
    }

    public int getCommandBatchingIndex() {
        return this.commandBatchingIndex;
    }

    @Override
    protected ExecutionAwareParameter createParameter(Method method, int parameterIndex) {
        return new ExecutionAwareParameter(method, parameterIndex);
    }

    public boolean hasCommandBatchingIndex() {
        return this.commandBatchingIndex != -1;
    }

    public boolean hasTimeoutIndex() {
        return this.getTimeoutIndex() != -1;
    }

    public static class ExecutionAwareParameter
    extends Parameter {
        public ExecutionAwareParameter(Method method, int parameterIndex) {
            super(method, parameterIndex);
        }

        @Override
        public boolean isSpecialParameter() {
            return super.isSpecialParameter() || TYPES.contains(this.getParameterType());
        }
    }
}

