/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.worldcomment.io.lettuce.core.dynamic.parameter;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.dynamic.parameter.Parameter;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.internal.LettuceAssert;

public abstract class Parameters<P extends Parameter>
implements Iterable<P> {
    private final List<P> parameters;
    private final List<P> bindableParameters;

    public Parameters(Method method) {
        LettuceAssert.notNull((Object)method, "Method must not be null");
        this.parameters = new ArrayList<P>(method.getParameterCount());
        for (int i = 0; i < method.getParameterCount(); ++i) {
            P parameter = this.createParameter(method, i);
            this.parameters.add(parameter);
        }
        this.bindableParameters = this.createBindableParameters();
    }

    protected abstract P createParameter(Method var1, int var2);

    private List<P> createBindableParameters() {
        ArrayList<Parameter> bindables = new ArrayList<Parameter>(this.parameters.size());
        for (Parameter parameter : this.parameters) {
            if (!parameter.isBindable()) continue;
            bindables.add(parameter);
        }
        return bindables;
    }

    public List<P> getParameters() {
        return this.parameters;
    }

    public Parameter getBindableParameter(int index) {
        return (Parameter)this.getBindableParameters().get(index);
    }

    public List<P> getBindableParameters() {
        return this.bindableParameters;
    }

    @Override
    public Iterator<P> iterator() {
        return this.getBindableParameters().iterator();
    }
}

