/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.worldcomment.io.lettuce.core.dynamic.segment;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.dynamic.segment.CommandSegment;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.internal.LettuceAssert;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.protocol.CommandType;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.protocol.ProtocolKeyword;

public class CommandSegments
implements Iterable<CommandSegment> {
    private final ProtocolKeyword commandType;
    private final List<CommandSegment> segments;

    public CommandSegments(List<CommandSegment> segments) {
        LettuceAssert.isTrue(!segments.isEmpty(), "Command segments must not be empty");
        this.segments = segments.size() > 1 ? Collections.unmodifiableList(segments.subList(1, segments.size())) : Collections.emptyList();
        this.commandType = this.potentiallyResolveCommand(segments.get(0).asString());
    }

    protected ProtocolKeyword potentiallyResolveCommand(String commandType) {
        try {
            return CommandType.valueOf(commandType);
        }
        catch (IllegalArgumentException e) {
            return new StringCommandType(commandType);
        }
    }

    @Override
    public Iterator<CommandSegment> iterator() {
        return this.segments.iterator();
    }

    public ProtocolKeyword getCommandType() {
        return this.commandType;
    }

    public int size() {
        return this.segments.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getCommandType().name());
        for (CommandSegment segment : this.segments) {
            sb.append(' ').append(segment);
        }
        return sb.toString();
    }

    static class StringCommandType
    implements ProtocolKeyword {
        private final byte[] commandTypeBytes;
        private final String commandType;

        StringCommandType(String commandType) {
            this.commandType = commandType;
            this.commandTypeBytes = commandType.getBytes();
        }

        @Override
        public byte[] getBytes() {
            return this.commandTypeBytes;
        }

        @Override
        public String name() {
            return this.commandType;
        }

        public String toString() {
            return this.name();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StringCommandType)) {
                return false;
            }
            StringCommandType that = (StringCommandType)o;
            return this.commandType.equals(that.commandType);
        }

        public int hashCode() {
            return this.commandType.hashCode();
        }
    }
}

