/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.worldcomment.io.lettuce.core.event.jfr;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.event.Event;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.event.jfr.EventRecorder;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.event.jfr.NoOpEventRecorder;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.internal.LettuceAssert;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.internal.LettuceClassUtils;

class JfrEventRecorder
implements EventRecorder {
    private final Map<Class<?>, Constructor<?>> constructorMap = new HashMap();

    JfrEventRecorder() {
    }

    @Override
    public void record(Event event) {
        LettuceAssert.notNull((Object)event, "Event must not be null");
        jdk.jfr.Event jfrEvent = this.createEvent(event);
        if (jfrEvent != null) {
            jfrEvent.commit();
        }
    }

    @Override
    public EventRecorder.RecordableEvent start(Event event) {
        LettuceAssert.notNull((Object)event, "Event must not be null");
        jdk.jfr.Event jfrEvent = this.createEvent(event);
        if (jfrEvent != null) {
            jfrEvent.begin();
            return new JfrRecordableEvent(jfrEvent);
        }
        return NoOpEventRecorder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Constructor<?> getEventConstructor(Event event) throws NoSuchMethodException {
        Constructor<Object> constructor;
        Map<Class<?>, Constructor<?>> map = this.constructorMap;
        synchronized (map) {
            constructor = this.constructorMap.get(event.getClass());
        }
        if (constructor == null) {
            String jfrClassName = event.getClass().getPackage().getName() + ".Jfr" + event.getClass().getSimpleName();
            Class<?> eventClass = LettuceClassUtils.findClass(jfrClassName);
            if (eventClass == null) {
                constructor = Object.class.getConstructor(new Class[0]);
            } else {
                constructor = eventClass.getDeclaredConstructors()[0];
                constructor.setAccessible(true);
            }
            Map<Class<?>, Constructor<?>> map2 = this.constructorMap;
            synchronized (map2) {
                this.constructorMap.put(event.getClass(), constructor);
            }
        }
        return constructor;
    }

    private jdk.jfr.Event createEvent(Event event) {
        try {
            Constructor<?> constructor = this.getEventConstructor(event);
            if (constructor.getDeclaringClass() == Object.class) {
                return null;
            }
            return (jdk.jfr.Event)constructor.newInstance(event);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException(e);
        }
    }

    static class JfrRecordableEvent
    implements EventRecorder.RecordableEvent {
        private final jdk.jfr.Event jfrEvent;

        public JfrRecordableEvent(jdk.jfr.Event jfrEvent) {
            this.jfrEvent = jfrEvent;
        }

        @Override
        public void record() {
            this.jfrEvent.end();
            this.jfrEvent.commit();
        }
    }
}

