/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.worldcomment.io.lettuce.core.event.metrics;

import java.util.concurrent.TimeUnit;
import jdk.jfr.Category;
import jdk.jfr.Description;
import jdk.jfr.Event;
import jdk.jfr.Label;
import jdk.jfr.StackTrace;
import jdk.jfr.Timespan;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.metrics.CommandLatencyId;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.metrics.CommandMetrics;

@Category(value={"Lettuce", "Command Events"})
@Label(value="Command Latency")
@StackTrace(value=false)
class JfrCommandLatency
extends Event {
    private final String remoteAddress;
    private final String commandType;
    private final long count;
    @Timespan(value="MICROSECONDS")
    @Description(value="First response latency minimum in \u00b5s")
    private final long firstResponseMin;
    @Timespan(value="MICROSECONDS")
    @Description(value="First response latency maximum in \u00b5s")
    private final long firstResponseMax;
    private final String firstResponsePercentiles;
    @Timespan(value="MICROSECONDS")
    @Description(value="Command response latency minimum in \u00b5s")
    private final long completionResponseMin;
    @Timespan(value="MICROSECONDS")
    @Description(value="Command response latency maximum in \u00b5s")
    private final long completionResponseMax;
    private final String completionResponsePercentiles;

    public JfrCommandLatency(CommandLatencyId commandLatencyId, CommandMetrics commandMetrics) {
        this.remoteAddress = commandLatencyId.remoteAddress().toString();
        this.commandType = commandLatencyId.commandType().toString();
        this.count = commandMetrics.getCount();
        CommandMetrics.CommandLatency firstResponse = commandMetrics.getFirstResponse();
        TimeUnit timeUnit = commandMetrics.getTimeUnit();
        this.firstResponseMin = timeUnit.toMicros(firstResponse.getMin());
        this.firstResponseMax = timeUnit.toMicros(firstResponse.getMax());
        this.firstResponsePercentiles = firstResponse.getPercentiles().toString();
        CommandMetrics.CommandLatency completion = commandMetrics.getCompletion();
        this.completionResponseMin = timeUnit.toMicros(completion.getMin());
        this.completionResponseMax = timeUnit.toMicros(completion.getMax());
        this.completionResponsePercentiles = completion.getPercentiles().toString();
    }
}

