/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.worldcomment.io.lettuce.core.internal;

import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.RedisCommandExecutionException;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.RedisCommandInterruptedException;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.RedisCommandTimeoutException;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.RedisException;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.internal.ExceptionFactory;

public class Exceptions {
    public static Throwable unwrap(Throwable t) {
        if (t instanceof ExecutionException || t instanceof CompletionException) {
            return t.getCause();
        }
        return t;
    }

    public static RuntimeException bubble(Throwable t) {
        Throwable throwableToUse = Exceptions.unwrap(t);
        if (throwableToUse instanceof TimeoutException) {
            return new RedisCommandTimeoutException(throwableToUse);
        }
        if (throwableToUse instanceof InterruptedException) {
            Thread.currentThread().interrupt();
            return new RedisCommandInterruptedException(throwableToUse);
        }
        if (throwableToUse instanceof RedisCommandExecutionException) {
            return ExceptionFactory.createExecutionException(throwableToUse.getMessage(), throwableToUse);
        }
        if (throwableToUse instanceof RedisException) {
            return (RedisException)throwableToUse;
        }
        if (throwableToUse instanceof RuntimeException) {
            return (RuntimeException)throwableToUse;
        }
        return new RedisException(throwableToUse);
    }

    public static RuntimeException fromSynchronization(Throwable t) {
        Throwable throwableToUse = Exceptions.unwrap(t);
        if (throwableToUse instanceof RedisCommandTimeoutException) {
            return new RedisCommandTimeoutException(throwableToUse);
        }
        if (throwableToUse instanceof RedisCommandExecutionException) {
            return Exceptions.bubble(throwableToUse);
        }
        if (throwableToUse instanceof RuntimeException) {
            return new RedisException(throwableToUse);
        }
        return Exceptions.bubble(throwableToUse);
    }
}

