/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.worldcomment.io.lettuce.core.masterreplica;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.RedisURI;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.masterreplica.CompletableEventLatchSupport;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.masterreplica.ReplicaUtils;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.masterreplica.TimedAsyncCommand;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.masterreplica.TopologyComparators;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.models.role.RedisNodeDescription;
import vendor.cn.zbx1425.worldcomment.reactor.util.function.Tuple2;
import vendor.cn.zbx1425.worldcomment.reactor.util.function.Tuples;

class Requests
extends CompletableEventLatchSupport<Tuple2<RedisURI, TimedAsyncCommand<String, String, String>>, List<RedisNodeDescription>> {
    private final Map<RedisURI, TimedAsyncCommand<String, String, String>> rawViews = new TreeMap<RedisURI, TimedAsyncCommand<String, String, String>>(ReplicaUtils.RedisURIComparator.INSTANCE);
    private final List<RedisNodeDescription> nodes;

    public Requests(int expectedCount, List<RedisNodeDescription> nodes) {
        super(expectedCount);
        this.nodes = nodes;
    }

    protected void addRequest(RedisURI redisURI, TimedAsyncCommand<String, String, String> command) {
        this.rawViews.put(redisURI, command);
        command.onComplete((s, throwable) -> {
            if (throwable != null) {
                this.accept((Throwable)throwable);
            } else {
                this.accept(Tuples.of(redisURI, command));
            }
        });
    }

    @Override
    protected void onEmit(CompletableEventLatchSupport.Emission<List<RedisNodeDescription>> emission) {
        ArrayList<RedisNodeDescription> result = new ArrayList<RedisNodeDescription>();
        HashMap<RedisNodeDescription, Long> latencies = new HashMap<RedisNodeDescription, Long>();
        for (RedisNodeDescription node : this.nodes) {
            TimedAsyncCommand<String, String, String> future = this.getRequest(node.getUri());
            if (future == null || !future.isDone()) continue;
            RedisNodeDescription redisNodeDescription = ReplicaUtils.findNodeByUri(this.nodes, node.getUri());
            latencies.put(redisNodeDescription, future.duration());
            result.add(redisNodeDescription);
        }
        TopologyComparators.SortAction sortAction = TopologyComparators.SortAction.getSortAction();
        sortAction.sort(result, new TopologyComparators.LatencyComparator(latencies));
        emission.success(result);
    }

    protected Set<RedisURI> nodes() {
        return this.rawViews.keySet();
    }

    protected TimedAsyncCommand<String, String, String> getRequest(RedisURI redisURI) {
        return this.rawViews.get(redisURI);
    }
}

