/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.worldcomment.io.lettuce.core.masterreplica;

import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.RedisClient;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.RedisException;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.RedisURI;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.codec.RedisCodec;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.event.jfr.EventRecorder;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.masterreplica.MasterReplicaChannelWriter;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.masterreplica.MasterReplicaConnectionProvider;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.masterreplica.MasterReplicaConnector;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.masterreplica.MasterReplicaTopologyChangedEvent;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.masterreplica.MasterReplicaTopologyRefresh;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.masterreplica.ResumeAfter;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.masterreplica.SentinelTopologyProvider;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.masterreplica.SentinelTopologyRefresh;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.masterreplica.StatefulRedisMasterReplicaConnection;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.masterreplica.StatefulRedisMasterReplicaConnectionImpl;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.models.role.RedisNodeDescription;
import vendor.cn.zbx1425.worldcomment.reactor.core.publisher.Mono;

class SentinelConnector<K, V>
implements MasterReplicaConnector<K, V> {
    private static final InternalLogger LOG = InternalLoggerFactory.getInstance(SentinelConnector.class);
    private final RedisClient redisClient;
    private final RedisCodec<K, V> codec;
    private final RedisURI redisURI;

    SentinelConnector(RedisClient redisClient, RedisCodec<K, V> codec, RedisURI redisURI) {
        this.redisClient = redisClient;
        this.codec = codec;
        this.redisURI = redisURI;
    }

    @Override
    public CompletableFuture<StatefulRedisMasterReplicaConnection<K, V>> connectAsync() {
        SentinelTopologyProvider topologyProvider = new SentinelTopologyProvider(this.redisURI.getSentinelMasterId(), this.redisClient, this.redisURI);
        SentinelTopologyRefresh sentinelTopologyRefresh = new SentinelTopologyRefresh(this.redisClient, this.redisURI.getSentinelMasterId(), this.redisURI.getSentinels());
        MasterReplicaTopologyRefresh refresh = new MasterReplicaTopologyRefresh(this.redisClient, topologyProvider);
        MasterReplicaConnectionProvider<K, V> connectionProvider = new MasterReplicaConnectionProvider<K, V>(this.redisClient, this.codec, this.redisURI, Collections.emptyMap());
        Runnable runnable = this.getTopologyRefreshRunnable(refresh, connectionProvider);
        return refresh.getNodes(this.redisURI).flatMap(nodes -> {
            if (nodes.isEmpty()) {
                return Mono.error(new RedisException(String.format("Cannot determine topology from %s", this.redisURI)));
            }
            return this.initializeConnection(this.codec, sentinelTopologyRefresh, connectionProvider, runnable, (List<RedisNodeDescription>)nodes);
        }).onErrorMap(ExecutionException.class, Throwable::getCause).toFuture();
    }

    private Mono<StatefulRedisMasterReplicaConnection<K, V>> initializeConnection(RedisCodec<K, V> codec, final SentinelTopologyRefresh sentinelTopologyRefresh, MasterReplicaConnectionProvider<K, V> connectionProvider, Runnable runnable, List<RedisNodeDescription> nodes) {
        connectionProvider.setKnownNodes(nodes);
        MasterReplicaChannelWriter channelWriter = new MasterReplicaChannelWriter(connectionProvider, this.redisClient.getResources()){

            @Override
            public CompletableFuture<Void> closeAsync() {
                return CompletableFuture.allOf(super.closeAsync(), sentinelTopologyRefresh.closeAsync());
            }
        };
        StatefulRedisMasterReplicaConnectionImpl connection = new StatefulRedisMasterReplicaConnectionImpl(channelWriter, codec, this.redisURI.getTimeout());
        connection.setOptions(this.redisClient.getOptions());
        CompletionStage<Void> bind = sentinelTopologyRefresh.bind(runnable);
        return Mono.fromCompletionStage(bind).onErrorResume(t -> ResumeAfter.close(connection).thenError((Throwable)t)).then(Mono.just(connection));
    }

    private Runnable getTopologyRefreshRunnable(MasterReplicaTopologyRefresh refresh, MasterReplicaConnectionProvider<K, V> connectionProvider) {
        return () -> {
            try {
                LOG.debug("Refreshing topology");
                refresh.getNodes(this.redisURI).subscribe(nodes -> {
                    EventRecorder.getInstance().record(new MasterReplicaTopologyChangedEvent(this.redisURI, (List<RedisNodeDescription>)nodes));
                    if (nodes.isEmpty()) {
                        LOG.warn("Topology refresh returned no nodes from {}", (Object)this.redisURI);
                    }
                    LOG.debug("New topology: {}", nodes);
                    connectionProvider.setKnownNodes((Collection<RedisNodeDescription>)nodes);
                }, t -> LOG.error("Error during background refresh", t));
            }
            catch (Exception e) {
                LOG.error("Error during background refresh", (Throwable)e);
            }
        };
    }
}

