/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.worldcomment.io.lettuce.core.masterreplica;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.RedisException;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.masterreplica.CompletableEventLatchSupport;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.pubsub.StatefulRedisPubSubConnection;

class SentinelTopologyRefreshConnections
extends CompletableEventLatchSupport<StatefulRedisPubSubConnection<String, String>, SentinelTopologyRefreshConnections> {
    private final List<Throwable> exceptions = new CopyOnWriteArrayList<Throwable>();
    private final AtomicInteger success = new AtomicInteger();

    public SentinelTopologyRefreshConnections(int expectedCount) {
        super(expectedCount);
    }

    @Override
    protected void onAccept(StatefulRedisPubSubConnection<String, String> value) {
        this.success.incrementAndGet();
    }

    @Override
    protected void onError(Throwable value) {
        this.exceptions.add(value);
    }

    @Override
    protected void onEmit(CompletableEventLatchSupport.Emission<SentinelTopologyRefreshConnections> emission) {
        if (this.success.get() == 0) {
            RedisException exception = new RedisException("Cannot attach to Redis Sentinel for topology refresh");
            this.exceptions.forEach(exception::addSuppressed);
            emission.error(exception);
        } else {
            emission.success(this);
        }
    }
}

