/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.worldcomment.io.lettuce.core.metrics;

import java.io.Serializable;
import java.net.SocketAddress;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.internal.LettuceAssert;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.protocol.ProtocolKeyword;

public class CommandLatencyId
implements Serializable,
Comparable<CommandLatencyId> {
    private final SocketAddress localAddress;
    private final SocketAddress remoteAddress;
    private final ProtocolKeyword commandType;
    private final String commandName;

    protected CommandLatencyId(SocketAddress localAddress, SocketAddress remoteAddress, ProtocolKeyword commandType) {
        LettuceAssert.notNull((Object)localAddress, "LocalAddress must not be null");
        LettuceAssert.notNull((Object)remoteAddress, "RemoteAddress must not be null");
        LettuceAssert.notNull((Object)commandType, "CommandType must not be null");
        this.localAddress = localAddress;
        this.remoteAddress = remoteAddress;
        this.commandType = commandType;
        this.commandName = commandType.name();
    }

    public static CommandLatencyId create(SocketAddress localAddress, SocketAddress remoteAddress, ProtocolKeyword commandType) {
        return new CommandLatencyId(localAddress, remoteAddress, commandType);
    }

    public SocketAddress localAddress() {
        return this.localAddress;
    }

    public SocketAddress remoteAddress() {
        return this.remoteAddress;
    }

    public ProtocolKeyword commandType() {
        return this.commandType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CommandLatencyId)) {
            return false;
        }
        CommandLatencyId that = (CommandLatencyId)o;
        if (!this.localAddress.equals(that.localAddress)) {
            return false;
        }
        if (!this.remoteAddress.equals(that.remoteAddress)) {
            return false;
        }
        return this.commandName.equals(that.commandName);
    }

    public int hashCode() {
        int result = this.localAddress.hashCode();
        result = 31 * result + this.remoteAddress.hashCode();
        result = 31 * result + this.commandName.hashCode();
        return result;
    }

    @Override
    public int compareTo(CommandLatencyId o) {
        if (o == null) {
            return -1;
        }
        int remoteResult = this.remoteAddress.toString().compareTo(o.remoteAddress.toString());
        if (remoteResult != 0) {
            return remoteResult;
        }
        int localResult = this.localAddress.toString().compareTo(o.localAddress.toString());
        if (localResult != 0) {
            return localResult;
        }
        return this.commandName.compareTo(o.commandName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(this.localAddress);
        sb.append(" -> ").append(this.remoteAddress);
        sb.append(", commandType=").append(this.commandType);
        sb.append(']');
        return sb.toString();
    }
}

