/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.worldcomment.io.lettuce.core.output;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.GeoCoordinates;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.Value;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.codec.RedisCodec;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.internal.LettuceAssert;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.output.CommandOutput;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.output.ListSubscriber;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.output.OutputFactory;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.output.StreamingOutput;

public class GeoCoordinatesValueListOutput<K, V>
extends CommandOutput<K, V, List<Value<GeoCoordinates>>>
implements StreamingOutput<Value<GeoCoordinates>> {
    private Double x;
    private boolean initialized;
    private StreamingOutput.Subscriber<Value<GeoCoordinates>> subscriber;

    public GeoCoordinatesValueListOutput(RedisCodec<K, V> codec) {
        super(codec, Collections.emptyList());
        this.setSubscriber((StreamingOutput.Subscriber<Value<GeoCoordinates>>)ListSubscriber.instance());
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (bytes == null) {
            this.subscriber.onNext((Collection)this.output, Value.empty());
            return;
        }
        double value = Double.parseDouble(this.decodeAscii(bytes));
        this.set(value);
    }

    @Override
    public void set(double number) {
        if (this.x == null) {
            this.x = number;
            return;
        }
        this.subscriber.onNext((Collection)this.output, Value.fromNullable(new GeoCoordinates(this.x, number)));
        this.x = null;
    }

    @Override
    public void multi(int count) {
        if (!this.initialized) {
            this.output = OutputFactory.newList(count / 2);
            this.initialized = true;
        }
        if (count == -1) {
            this.subscriber.onNext((Collection)this.output, Value.empty());
        }
    }

    @Override
    public void setSubscriber(StreamingOutput.Subscriber<Value<GeoCoordinates>> subscriber) {
        LettuceAssert.notNull(subscriber, "Subscriber must not be null");
        this.subscriber = subscriber;
    }

    @Override
    public StreamingOutput.Subscriber<Value<GeoCoordinates>> getSubscriber() {
        return this.subscriber;
    }
}

