/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.worldcomment.io.lettuce.core.output;

import java.nio.ByteBuffer;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.StreamScanCursor;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.codec.RedisCodec;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.output.KeyValueStreamingChannel;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.output.ScanOutput;

public class KeyValueScanStreamingOutput<K, V>
extends ScanOutput<K, V, StreamScanCursor> {
    private K key;
    private KeyValueStreamingChannel<K, V> channel;

    public KeyValueScanStreamingOutput(RedisCodec<K, V> codec, KeyValueStreamingChannel<K, V> channel) {
        super(codec, new StreamScanCursor());
        this.channel = channel;
    }

    @Override
    protected void setOutput(ByteBuffer bytes) {
        if (this.key == null) {
            this.key = this.codec.decodeKey(bytes);
            return;
        }
        Object value = bytes == null ? null : (Object)this.codec.decodeValue(bytes);
        this.channel.onKeyValue(this.key, value);
        ((StreamScanCursor)this.output).setCount(((StreamScanCursor)this.output).getCount() + 1L);
        this.key = null;
    }
}

