/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.worldcomment.io.lettuce.core.output;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.codec.RedisCodec;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.output.CommandOutput;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.output.GenericMapOutput;

public class ListOfGenericMapsOutput<K, V>
extends CommandOutput<K, V, List<Map<K, Object>>> {
    private final GenericMapOutput<K, V> nested;
    private int mapCount = -1;
    private final List<Integer> counts = new ArrayList<Integer>();

    public ListOfGenericMapsOutput(RedisCodec<K, V> codec) {
        super(codec, new ArrayList());
        this.nested = new GenericMapOutput<K, V>(codec);
    }

    @Override
    public void set(ByteBuffer bytes) {
        this.nested.set(bytes);
    }

    @Override
    public void complete(int depth) {
        if (this.counts.size() > 0) {
            int expectedSize = this.counts.get(0);
            if (((Map)this.nested.get()).size() == expectedSize) {
                this.counts.remove(0);
                ((List)this.output).add(new LinkedHashMap((Map)this.nested.get()));
                ((Map)this.nested.get()).clear();
            }
        }
    }

    @Override
    public void multi(int count) {
        this.nested.multi(count);
        if (this.mapCount == -1) {
            this.mapCount = count;
        } else {
            this.counts.add(count / 2);
        }
    }

    @Override
    public void set(long integer) {
        this.nested.set(integer);
    }

    @Override
    public void set(double number) {
        this.nested.set(number);
    }
}

