/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.worldcomment.io.lettuce.core.output;

import java.nio.ByteBuffer;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.ScoredValue;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.codec.RedisCodec;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.internal.LettuceStrings;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.output.CommandOutput;

public class ScoredValueOutput<K, V>
extends CommandOutput<K, V, ScoredValue<V>> {
    private V value;

    public ScoredValueOutput(RedisCodec<K, V> codec) {
        super(codec, ScoredValue.empty());
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (bytes == null) {
            return;
        }
        if (this.value == null) {
            this.value = this.codec.decodeValue(bytes);
            return;
        }
        double score = LettuceStrings.toDouble(this.decodeAscii(bytes));
        this.set(score);
    }

    @Override
    public void set(double number) {
        this.output = ScoredValue.just(number, this.value);
        this.value = null;
    }
}

