/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.worldcomment.io.lettuce.core.output;

import java.nio.ByteBuffer;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.ScoredValue;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.ScoredValueScanCursor;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.codec.RedisCodec;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.internal.LettuceStrings;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.output.ScanOutput;

public class ScoredValueScanOutput<K, V>
extends ScanOutput<K, V, ScoredValueScanCursor<V>> {
    private V value;

    public ScoredValueScanOutput(RedisCodec<K, V> codec) {
        super(codec, new ScoredValueScanCursor());
    }

    @Override
    protected void setOutput(ByteBuffer bytes) {
        if (this.value == null) {
            this.value = this.codec.decodeValue(bytes);
            return;
        }
        double score = LettuceStrings.toDouble(this.decodeAscii(bytes));
        this.set(score);
    }

    @Override
    public void set(double number) {
        if (this.value != null) {
            ((ScoredValueScanCursor)this.output).getValues().add(ScoredValue.just(number, this.value));
        }
        this.value = null;
    }
}

