/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.worldcomment.io.lettuce.core.output;

import java.nio.ByteBuffer;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.ScoredValue;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.StreamScanCursor;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.codec.RedisCodec;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.internal.LettuceStrings;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.output.ScanOutput;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.output.ScoredValueStreamingChannel;

public class ScoredValueScanStreamingOutput<K, V>
extends ScanOutput<K, V, StreamScanCursor> {
    private final ScoredValueStreamingChannel<V> channel;
    private V value;

    public ScoredValueScanStreamingOutput(RedisCodec<K, V> codec, ScoredValueStreamingChannel<V> channel) {
        super(codec, new StreamScanCursor());
        this.channel = channel;
    }

    @Override
    protected void setOutput(ByteBuffer bytes) {
        if (this.value == null) {
            this.value = this.codec.decodeValue(bytes);
            return;
        }
        double score = LettuceStrings.toDouble(this.decodeAscii(bytes));
        this.set(score);
    }

    @Override
    public void set(double number) {
        if (this.value != null) {
            this.channel.onValue(ScoredValue.just(number, this.value));
        }
        this.value = null;
        ((StreamScanCursor)this.output).setCount(((StreamScanCursor)this.output).getCount() + 1L);
    }
}

