/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.worldcomment.io.lettuce.core.output;

import java.nio.ByteBuffer;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.ScoredValue;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.codec.RedisCodec;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.internal.LettuceStrings;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.output.CommandOutput;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.output.ScoredValueStreamingChannel;

public class ScoredValueStreamingOutput<K, V>
extends CommandOutput<K, V, Long> {
    private V value;
    private final ScoredValueStreamingChannel<V> channel;

    public ScoredValueStreamingOutput(RedisCodec<K, V> codec, ScoredValueStreamingChannel<V> channel) {
        super(codec, 0L);
        this.channel = channel;
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (this.value == null) {
            this.value = this.codec.decodeValue(bytes);
            return;
        }
        double score = LettuceStrings.toDouble(this.decodeAscii(bytes));
        this.set(score);
    }

    @Override
    public void set(double number) {
        this.channel.onValue(ScoredValue.just(number, this.value));
        this.value = null;
        this.output = (Long)this.output + 1L;
    }
}

