/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.worldcomment.io.lettuce.core.output;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.StreamMessage;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.codec.RedisCodec;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.internal.LettuceAssert;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.output.CommandOutput;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.output.ListSubscriber;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.output.OutputFactory;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.output.StreamingOutput;

public class StreamMessageListOutput<K, V>
extends CommandOutput<K, V, List<StreamMessage<K, V>>>
implements StreamingOutput<StreamMessage<K, V>> {
    private final K stream;
    private boolean initialized;
    private StreamingOutput.Subscriber<StreamMessage<K, V>> subscriber;
    private K key;
    private String id;
    private Map<K, V> body;

    public StreamMessageListOutput(RedisCodec<K, V> codec, K stream) {
        super(codec, Collections.emptyList());
        this.setSubscriber((StreamingOutput.Subscriber<StreamMessage<K, V>>)ListSubscriber.instance());
        this.stream = stream;
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (this.id == null) {
            this.id = this.decodeAscii(bytes);
            return;
        }
        if (this.key == null) {
            this.key = this.codec.decodeKey(bytes);
            return;
        }
        if (this.body == null) {
            this.body = new LinkedHashMap();
        }
        this.body.put(this.key, bytes == null ? null : (Object)this.codec.decodeValue(bytes));
        this.key = null;
    }

    @Override
    public void multi(int count) {
        if (!this.initialized) {
            this.output = OutputFactory.newList(count);
            this.initialized = true;
        }
    }

    @Override
    public void complete(int depth) {
        if (depth == 1) {
            this.subscriber.onNext((Collection)this.output, new StreamMessage<K, V>(this.stream, this.id, this.body));
            this.key = null;
            this.id = null;
            this.body = null;
        }
    }

    @Override
    public void setSubscriber(StreamingOutput.Subscriber<StreamMessage<K, V>> subscriber) {
        LettuceAssert.notNull(subscriber, "Subscriber must not be null");
        this.subscriber = subscriber;
    }

    @Override
    public StreamingOutput.Subscriber<StreamMessage<K, V>> getSubscriber() {
        return this.subscriber;
    }
}

