/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.worldcomment.io.lettuce.core.output;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.codec.RedisCodec;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.internal.LettuceAssert;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.output.CommandOutput;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.output.ListSubscriber;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.output.OutputFactory;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.output.StreamingOutput;

public class StringListOutput<K, V>
extends CommandOutput<K, V, List<String>>
implements StreamingOutput<String> {
    private boolean initialized;
    private StreamingOutput.Subscriber<String> subscriber;

    public StringListOutput(RedisCodec<K, V> codec) {
        super(codec, Collections.emptyList());
        this.setSubscriber((StreamingOutput.Subscriber<String>)ListSubscriber.instance());
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (!this.initialized) {
            this.multi(1);
        }
        this.subscriber.onNext((Collection)this.output, bytes == null ? null : this.decodeAscii(bytes));
    }

    @Override
    public void multi(int count) {
        if (!this.initialized) {
            this.output = OutputFactory.newList(count);
            this.initialized = true;
        }
    }

    @Override
    public void setSubscriber(StreamingOutput.Subscriber<String> subscriber) {
        LettuceAssert.notNull(subscriber, "Subscriber must not be null");
        this.subscriber = subscriber;
    }

    @Override
    public StreamingOutput.Subscriber<String> getSubscriber() {
        return this.subscriber;
    }
}

