/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.worldcomment.io.lettuce.core.protocol;

import io.netty.buffer.ByteBuf;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.RedisCommandInterruptedException;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.RedisFuture;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.internal.ExceptionFactory;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.internal.LettuceAssert;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.output.CommandOutput;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.protocol.CommandArgs;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.protocol.CommandWrapper;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.protocol.CompleteableCommand;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.protocol.DecoratedCommand;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.protocol.ProtocolKeyword;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.protocol.RedisCommand;

public class AsyncCommand<K, V, T>
extends CompletableFuture<T>
implements RedisCommand<K, V, T>,
RedisFuture<T>,
CompleteableCommand<T>,
DecoratedCommand<K, V, T> {
    private static final AtomicIntegerFieldUpdater<AsyncCommand> COUNT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(AsyncCommand.class, "count");
    private final RedisCommand<K, V, T> command;
    private volatile int count = 1;

    public AsyncCommand(RedisCommand<K, V, T> command) {
        this(command, 1);
    }

    protected AsyncCommand(RedisCommand<K, V, T> command, int count) {
        LettuceAssert.notNull(command, "RedisCommand must not be null");
        this.command = command;
        this.count = count;
    }

    @Override
    public boolean await(long timeout, TimeUnit unit) {
        try {
            this.get(timeout, unit);
            return true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RedisCommandInterruptedException(e);
        }
        catch (ExecutionException e) {
            return true;
        }
        catch (TimeoutException e) {
            return false;
        }
    }

    @Override
    public CommandOutput<K, V, T> getOutput() {
        return this.command.getOutput();
    }

    @Override
    public void complete() {
        if (COUNT_UPDATER.decrementAndGet(this) == 0) {
            this.completeResult();
            this.command.complete();
        }
    }

    protected void completeResult() {
        if (this.command.getOutput() == null) {
            this.complete(null);
        } else if (this.command.getOutput().hasError()) {
            this.doCompleteExceptionally(ExceptionFactory.createExecutionException(this.command.getOutput().getError()));
        } else {
            this.complete(this.command.getOutput().get());
        }
    }

    @Override
    public boolean completeExceptionally(Throwable ex) {
        boolean result = false;
        int ref = COUNT_UPDATER.get(this);
        if (ref > 0 && COUNT_UPDATER.compareAndSet(this, ref, 0)) {
            result = this.doCompleteExceptionally(ex);
        }
        return result;
    }

    private boolean doCompleteExceptionally(Throwable ex) {
        this.command.completeExceptionally(ex);
        return super.completeExceptionally(ex);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        try {
            this.command.cancel();
            boolean bl = super.cancel(mayInterruptIfRunning);
            return bl;
        }
        finally {
            COUNT_UPDATER.set(this, 0);
        }
    }

    @Override
    public String getError() {
        return this.command.getOutput().getError();
    }

    @Override
    public CommandArgs<K, V> getArgs() {
        return this.command.getArgs();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [type=").append(this.getType());
        sb.append(", output=").append(this.getOutput());
        sb.append(", commandType=").append(this.command.getClass().getName());
        sb.append(']');
        return sb.toString();
    }

    @Override
    public ProtocolKeyword getType() {
        return this.command.getType();
    }

    @Override
    public void cancel() {
        this.cancel(true);
    }

    @Override
    public void encode(ByteBuf buf) {
        this.command.encode(buf);
    }

    @Override
    public void setOutput(CommandOutput<K, V, T> output) {
        this.command.setOutput(output);
    }

    @Override
    public void onComplete(Consumer<? super T> action) {
        this.thenAccept((Consumer)action);
    }

    @Override
    public void onComplete(BiConsumer<? super T, Throwable> action) {
        this.whenComplete(action);
    }

    @Override
    public RedisCommand<K, V, T> getDelegate() {
        return this.command;
    }

    public boolean equals(Object o) {
        RedisCommand right;
        if (this == o) {
            return true;
        }
        if (!(o instanceof RedisCommand)) {
            return false;
        }
        RedisCommand<K, V, T> left = CommandWrapper.unwrap(this.command);
        return left == (right = CommandWrapper.unwrap((RedisCommand)o));
    }

    public int hashCode() {
        RedisCommand<K, V, T> toHash = CommandWrapper.unwrap(this.command);
        return toHash != null ? toHash.hashCode() : 0;
    }
}

