/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.worldcomment.io.lettuce.core.protocol;

import vendor.cn.zbx1425.worldcomment.io.lettuce.core.RedisException;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.ScriptOutputType;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.codec.RedisCodec;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.output.BooleanOutput;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.output.CommandOutput;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.output.IntegerOutput;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.output.NestedMultiOutput;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.output.StatusOutput;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.output.ValueOutput;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.protocol.Command;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.protocol.CommandArgs;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.protocol.CommandType;

public class BaseRedisCommandBuilder<K, V> {
    protected final RedisCodec<K, V> codec;

    public BaseRedisCommandBuilder(RedisCodec<K, V> codec) {
        this.codec = codec;
    }

    protected <T> Command<K, V, T> createCommand(CommandType type, CommandOutput<K, V, T> output) {
        return this.createCommand(type, output, (CommandArgs)null);
    }

    protected <T> Command<K, V, T> createCommand(CommandType type, CommandOutput<K, V, T> output, K key) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(key);
        return this.createCommand(type, output, args);
    }

    protected <T> Command<K, V, T> createCommand(CommandType type, CommandOutput<K, V, T> output, K key, V value) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(key).addValue(value);
        return this.createCommand(type, output, args);
    }

    protected <T> Command<K, V, T> createCommand(CommandType type, CommandOutput<K, V, T> output, K key, V[] values) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(key).addValues(values);
        return this.createCommand(type, output, args);
    }

    protected <T> Command<K, V, T> createCommand(CommandType type, CommandOutput<K, V, T> output, CommandArgs<K, V> args) {
        return new Command<K, V, T>(type, output, args);
    }

    protected <T> CommandOutput<K, V, T> newScriptOutput(RedisCodec<K, V> codec, ScriptOutputType type) {
        switch (type) {
            case BOOLEAN: {
                return new BooleanOutput<K, V>(codec);
            }
            case INTEGER: {
                return new IntegerOutput<K, V>(codec);
            }
            case STATUS: {
                return new StatusOutput<K, V>(codec);
            }
            case MULTI: {
                return new NestedMultiOutput<K, V>(codec);
            }
            case VALUE: {
                return new ValueOutput<K, V>(codec);
            }
        }
        throw new RedisException("Unsupported script output type");
    }
}

