/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.worldcomment.io.lettuce.core.protocol;

import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.ClientOptions;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.RedisChannelWriter;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.TimeoutOptions;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.internal.ExceptionFactory;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.internal.LettuceAssert;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.protocol.CompleteableCommand;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.protocol.ConnectionFacade;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.protocol.RedisCommand;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.resource.ClientResources;

public class CommandExpiryWriter
implements RedisChannelWriter {
    private final RedisChannelWriter delegate;
    private final TimeoutOptions.TimeoutSource source;
    private final TimeUnit timeUnit;
    private final ScheduledExecutorService executorService;
    private final boolean applyConnectionTimeout;
    private volatile long timeout = -1L;

    public CommandExpiryWriter(RedisChannelWriter delegate, ClientOptions clientOptions, ClientResources clientResources) {
        LettuceAssert.notNull((Object)delegate, "RedisChannelWriter must not be null");
        LettuceAssert.isTrue(CommandExpiryWriter.isSupported(clientOptions), "Command timeout not enabled");
        LettuceAssert.notNull((Object)clientResources, "ClientResources must not be null");
        TimeoutOptions timeoutOptions = clientOptions.getTimeoutOptions();
        this.delegate = delegate;
        this.source = timeoutOptions.getSource();
        this.applyConnectionTimeout = timeoutOptions.isApplyConnectionTimeout();
        this.timeUnit = this.source.getTimeUnit();
        this.executorService = clientResources.eventExecutorGroup();
    }

    public static boolean isSupported(ClientOptions clientOptions) {
        LettuceAssert.notNull((Object)clientOptions, "ClientOptions must not be null");
        return CommandExpiryWriter.isSupported(clientOptions.getTimeoutOptions());
    }

    private static boolean isSupported(TimeoutOptions timeoutOptions) {
        LettuceAssert.notNull((Object)timeoutOptions, "TimeoutOptions must not be null");
        return timeoutOptions.isTimeoutCommands();
    }

    @Override
    public void setConnectionFacade(ConnectionFacade connectionFacade) {
        this.delegate.setConnectionFacade(connectionFacade);
    }

    @Override
    public ClientResources getClientResources() {
        return this.delegate.getClientResources();
    }

    @Override
    public void setAutoFlushCommands(boolean autoFlush) {
        this.delegate.setAutoFlushCommands(autoFlush);
    }

    @Override
    public <K, V, T> RedisCommand<K, V, T> write(RedisCommand<K, V, T> command) {
        this.potentiallyExpire(command, this.getExecutorService());
        return this.delegate.write(command);
    }

    @Override
    public <K, V> Collection<RedisCommand<K, V, ?>> write(Collection<? extends RedisCommand<K, V, ?>> redisCommands) {
        ScheduledExecutorService executorService = this.getExecutorService();
        for (RedisCommand<K, V, ?> command : redisCommands) {
            this.potentiallyExpire(command, executorService);
        }
        return this.delegate.write(redisCommands);
    }

    @Override
    public void flushCommands() {
        this.delegate.flushCommands();
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public CompletableFuture<Void> closeAsync() {
        return this.delegate.closeAsync();
    }

    @Override
    public void reset() {
        this.delegate.reset();
    }

    public void setTimeout(Duration timeout) {
        this.timeout = this.timeUnit.convert(timeout.toNanos(), TimeUnit.NANOSECONDS);
    }

    public RedisChannelWriter getDelegate() {
        return this.delegate;
    }

    private ScheduledExecutorService getExecutorService() {
        return this.executorService;
    }

    private void potentiallyExpire(RedisCommand<?, ?, ?> command, ScheduledExecutorService executors) {
        long timeout;
        long l = timeout = this.applyConnectionTimeout ? this.timeout : this.source.getTimeout(command);
        if (timeout <= 0L) {
            return;
        }
        ScheduledFuture<?> schedule = executors.schedule(() -> {
            if (!command.isDone()) {
                command.completeExceptionally(ExceptionFactory.createTimeoutException(Duration.ofNanos(this.timeUnit.toNanos(timeout))));
            }
        }, timeout, this.timeUnit);
        if (command instanceof CompleteableCommand) {
            ((CompleteableCommand)((Object)command)).onComplete((o, o2) -> {
                if (!schedule.isDone()) {
                    schedule.cancel(false);
                }
            });
        }
    }
}

