/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.worldcomment.io.lettuce.core.support.caching;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.StatefulRedisConnectionImpl;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.TrackingArgs;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.api.StatefulRedisConnection;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.codec.RedisCodec;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.support.caching.CacheAccessor;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.support.caching.CacheFrontend;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.support.caching.DefaultRedisCache;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.support.caching.RedisCache;

public class ClientSideCaching<K, V>
implements CacheFrontend<K, V> {
    private final CacheAccessor<K, V> cacheAccessor;
    private final RedisCache<K, V> redisCache;
    private final List<Consumer<K>> invalidationListeners = new CopyOnWriteArrayList<Consumer<K>>();

    private ClientSideCaching(CacheAccessor<K, V> cacheAccessor, RedisCache<K, V> redisCache) {
        this.cacheAccessor = cacheAccessor;
        this.redisCache = redisCache;
    }

    public static <K, V> CacheFrontend<K, V> enable(CacheAccessor<K, V> cacheAccessor, StatefulRedisConnection<K, V> connection, TrackingArgs tracking) {
        connection.sync().clientTracking(tracking);
        return ClientSideCaching.create(cacheAccessor, connection);
    }

    public static <K, V> CacheFrontend<K, V> create(CacheAccessor<K, V> cacheAccessor, StatefulRedisConnection<K, V> connection) {
        StatefulRedisConnectionImpl connectionImpl = (StatefulRedisConnectionImpl)connection;
        RedisCodec codec = connectionImpl.getCodec();
        DefaultRedisCache<K, V> redisCache = new DefaultRedisCache<K, V>(connection, codec);
        return ClientSideCaching.create(cacheAccessor, redisCache);
    }

    private static <K, V> CacheFrontend<K, V> create(CacheAccessor<K, V> cacheAccessor, RedisCache<K, V> redisCache) {
        ClientSideCaching<Object, V> caching = new ClientSideCaching<Object, V>(cacheAccessor, redisCache);
        redisCache.addInvalidationListener(caching::notifyInvalidate);
        caching.addInvalidationListener(cacheAccessor::evict);
        return caching;
    }

    private void notifyInvalidate(K key) {
        for (Consumer<K> invalidationListener : this.invalidationListeners) {
            invalidationListener.accept(key);
        }
    }

    @Override
    public void close() {
        this.redisCache.close();
    }

    public void addInvalidationListener(Consumer<K> invalidationListener) {
        this.invalidationListeners.add(invalidationListener);
    }

    @Override
    public V get(K key) {
        V value = this.cacheAccessor.get(key);
        if (value == null && (value = this.redisCache.get(key)) != null) {
            this.cacheAccessor.put(key, value);
        }
        return value;
    }

    @Override
    public V get(K key, Callable<V> valueLoader) {
        V value = this.cacheAccessor.get(key);
        if (value == null) {
            value = this.redisCache.get(key);
            if (value == null) {
                try {
                    value = valueLoader.call();
                }
                catch (Exception e) {
                    throw new CacheFrontend.ValueRetrievalException(String.format("Value loader %s failed with an exception for key %s", valueLoader, key), e);
                }
                if (value == null) {
                    throw new CacheFrontend.ValueRetrievalException(String.format("Value loader %s returned a null value for key %s", valueLoader, key));
                }
                this.redisCache.put(key, value);
                this.redisCache.get(key);
            }
            this.cacheAccessor.put(key, value);
        }
        return value;
    }
}

