/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.worldcomment.reactor.core.publisher;

import java.util.concurrent.Callable;
import vendor.cn.zbx1425.worldcomment.reactor.core.CoreSubscriber;
import vendor.cn.zbx1425.worldcomment.reactor.core.Fuseable;
import vendor.cn.zbx1425.worldcomment.reactor.core.Scannable;
import vendor.cn.zbx1425.worldcomment.reactor.core.publisher.Flux;
import vendor.cn.zbx1425.worldcomment.reactor.core.publisher.Operators;
import vendor.cn.zbx1425.worldcomment.reactor.core.publisher.SourceProducer;
import vendor.cn.zbx1425.worldcomment.reactor.util.annotation.Nullable;

final class FluxCallable<T>
extends Flux<T>
implements Callable<T>,
Fuseable,
SourceProducer<T> {
    final Callable<T> callable;

    FluxCallable(Callable<T> callable) {
        this.callable = callable;
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        Operators.MonoSubscriber wrapper = new Operators.MonoSubscriber(actual);
        actual.onSubscribe(wrapper);
        try {
            T v = this.callable.call();
            if (v == null) {
                wrapper.onComplete();
            } else {
                wrapper.complete(v);
            }
        }
        catch (Throwable ex) {
            actual.onError(Operators.onOperatorError(ex, actual.currentContext()));
        }
    }

    @Override
    @Nullable
    public T call() throws Exception {
        return this.callable.call();
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return null;
    }
}

