/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.worldcomment.reactor.core.publisher;

import java.util.Objects;
import java.util.function.Function;
import vendor.cn.zbx1425.worldcomment.org.reactivestreams.Publisher;
import vendor.cn.zbx1425.worldcomment.reactor.core.CoreSubscriber;
import vendor.cn.zbx1425.worldcomment.reactor.core.Scannable;
import vendor.cn.zbx1425.worldcomment.reactor.core.publisher.Flux;
import vendor.cn.zbx1425.worldcomment.reactor.core.publisher.Operators;
import vendor.cn.zbx1425.worldcomment.reactor.core.publisher.SourceProducer;
import vendor.cn.zbx1425.worldcomment.reactor.util.context.Context;
import vendor.cn.zbx1425.worldcomment.reactor.util.context.ContextView;

final class FluxDeferContextual<T>
extends Flux<T>
implements SourceProducer<T> {
    final Function<ContextView, ? extends Publisher<? extends T>> contextualPublisherFactory;

    FluxDeferContextual(Function<ContextView, ? extends Publisher<? extends T>> contextualPublisherFactory) {
        this.contextualPublisherFactory = Objects.requireNonNull(contextualPublisherFactory, "contextualPublisherFactory");
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        Publisher<? extends T> p;
        Context ctx = actual.currentContext();
        try {
            p = Objects.requireNonNull(this.contextualPublisherFactory.apply(ctx.readOnly()), "The Publisher returned by the contextualPublisherFactory is null");
        }
        catch (Throwable e) {
            Operators.error(actual, Operators.onOperatorError(e, ctx));
            return;
        }
        FluxDeferContextual.from(p).subscribe(actual);
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return null;
    }
}

