/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.worldcomment.reactor.core.publisher;

import vendor.cn.zbx1425.worldcomment.org.reactivestreams.Subscription;
import vendor.cn.zbx1425.worldcomment.reactor.core.CoreSubscriber;
import vendor.cn.zbx1425.worldcomment.reactor.core.Scannable;
import vendor.cn.zbx1425.worldcomment.reactor.core.publisher.Flux;
import vendor.cn.zbx1425.worldcomment.reactor.core.publisher.InnerOperator;
import vendor.cn.zbx1425.worldcomment.reactor.core.publisher.InternalFluxOperator;
import vendor.cn.zbx1425.worldcomment.reactor.core.publisher.Operators;
import vendor.cn.zbx1425.worldcomment.reactor.util.annotation.Nullable;
import vendor.cn.zbx1425.worldcomment.reactor.util.context.Context;

final class FluxDetach<T>
extends InternalFluxOperator<T, T> {
    FluxDetach(Flux<? extends T> source) {
        super(source);
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super T> actual) {
        return new DetachSubscriber<T>(actual);
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return super.scanUnsafe(key);
    }

    static final class DetachSubscriber<T>
    implements InnerOperator<T, T> {
        CoreSubscriber<? super T> actual;
        Subscription s;

        DetachSubscriber(CoreSubscriber<? super T> actual) {
            this.actual = actual;
        }

        @Override
        public Context currentContext() {
            return this.actual == null ? Context.empty() : this.actual.currentContext();
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            if (key == Scannable.Attr.TERMINATED) {
                return this.actual == null;
            }
            if (key == Scannable.Attr.CANCELLED) {
                return this.actual == null && this.s == null;
            }
            if (key == Scannable.Attr.RUN_STYLE) {
                return Scannable.Attr.RunStyle.SYNC;
            }
            return InnerOperator.super.scanUnsafe(key);
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            CoreSubscriber<T> a = this.actual;
            if (a != null) {
                a.onNext(t);
            }
        }

        @Override
        public void onError(Throwable t) {
            CoreSubscriber<T> a = this.actual;
            if (a != null) {
                this.actual = null;
                this.s = null;
                a.onError(t);
            }
        }

        @Override
        public CoreSubscriber<? super T> actual() {
            return this.actual;
        }

        @Override
        public void onComplete() {
            CoreSubscriber<T> a = this.actual;
            if (a != null) {
                this.actual = null;
                this.s = null;
                a.onComplete();
            }
        }

        @Override
        public void request(long n) {
            Subscription a = this.s;
            if (a != null) {
                a.request(n);
            }
        }

        @Override
        public void cancel() {
            Subscription a = this.s;
            if (a != null) {
                this.actual = null;
                this.s = null;
                a.cancel();
            }
        }
    }
}

