/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.worldcomment.reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import vendor.cn.zbx1425.worldcomment.reactor.core.CoreSubscriber;
import vendor.cn.zbx1425.worldcomment.reactor.core.Exceptions;
import vendor.cn.zbx1425.worldcomment.reactor.core.Fuseable;
import vendor.cn.zbx1425.worldcomment.reactor.core.Scannable;
import vendor.cn.zbx1425.worldcomment.reactor.core.publisher.Mono;
import vendor.cn.zbx1425.worldcomment.reactor.core.publisher.Operators;
import vendor.cn.zbx1425.worldcomment.reactor.util.context.Context;

final class MonoCompletionStage<T>
extends Mono<T>
implements Fuseable,
Scannable {
    final CompletionStage<? extends T> future;
    final boolean suppressCancellation;

    MonoCompletionStage(CompletionStage<? extends T> future, boolean suppressCancellation) {
        this.future = Objects.requireNonNull(future, "future");
        this.suppressCancellation = suppressCancellation;
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        Operators.MonoSubscriber sds = this.suppressCancellation ? new Operators.MonoSubscriber(actual) : new Operators.MonoSubscriber<T, T>(actual){

            @Override
            public void cancel() {
                super.cancel();
                if (MonoCompletionStage.this.future instanceof Future) {
                    ((Future)((Object)MonoCompletionStage.this.future)).cancel(true);
                }
            }
        };
        actual.onSubscribe(sds);
        if (sds.isCancelled()) {
            return;
        }
        this.future.handle((? super T v, Throwable e) -> {
            if (sds.isCancelled()) {
                Context ctx = sds.currentContext();
                if (e == null || e instanceof CancellationException) {
                    Operators.onDiscard(v, ctx);
                } else {
                    Operators.onErrorDropped(e, ctx);
                    Operators.onDiscard(v, ctx);
                }
                return null;
            }
            try {
                if (e instanceof CompletionException) {
                    actual.onError(e.getCause());
                } else if (e != null) {
                    actual.onError((Throwable)e);
                } else if (v != null) {
                    sds.complete(v);
                } else {
                    actual.onComplete();
                }
            }
            catch (Throwable e1) {
                Operators.onErrorDropped(e1, actual.currentContext());
                throw Exceptions.bubble(e1);
            }
            return null;
        });
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.ASYNC;
        }
        return null;
    }
}

