/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.worldcomment.reactor.core.publisher;

import vendor.cn.zbx1425.worldcomment.reactor.core.CoreSubscriber;
import vendor.cn.zbx1425.worldcomment.reactor.core.Scannable;
import vendor.cn.zbx1425.worldcomment.reactor.core.publisher.FluxFromMonoOperator;
import vendor.cn.zbx1425.worldcomment.reactor.core.publisher.FluxRepeat;
import vendor.cn.zbx1425.worldcomment.reactor.core.publisher.Mono;

final class MonoRepeat<T>
extends FluxFromMonoOperator<T, T> {
    final long times;

    MonoRepeat(Mono<? extends T> source, long times) {
        super(source);
        if (times <= 0L) {
            throw new IllegalArgumentException("times > 0 required");
        }
        this.times = times;
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super T> actual) {
        FluxRepeat.RepeatSubscriber<T> parent = new FluxRepeat.RepeatSubscriber<T>(this.source, actual, this.times + 1L);
        actual.onSubscribe(parent);
        if (!parent.isCancelled()) {
            parent.onComplete();
        }
        return null;
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return super.scanUnsafe(key);
    }
}

