/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.worldcomment.reactor.core.publisher;

import java.util.NoSuchElementException;
import java.util.Objects;
import vendor.cn.zbx1425.worldcomment.org.reactivestreams.Subscription;
import vendor.cn.zbx1425.worldcomment.reactor.core.CoreSubscriber;
import vendor.cn.zbx1425.worldcomment.reactor.core.Fuseable;
import vendor.cn.zbx1425.worldcomment.reactor.core.Scannable;
import vendor.cn.zbx1425.worldcomment.reactor.core.publisher.Flux;
import vendor.cn.zbx1425.worldcomment.reactor.core.publisher.MonoFromFluxOperator;
import vendor.cn.zbx1425.worldcomment.reactor.core.publisher.Operators;
import vendor.cn.zbx1425.worldcomment.reactor.util.annotation.Nullable;

final class MonoTakeLastOne<T>
extends MonoFromFluxOperator<T, T>
implements Fuseable {
    final T defaultValue;

    MonoTakeLastOne(Flux<? extends T> source) {
        super(source);
        this.defaultValue = null;
    }

    MonoTakeLastOne(Flux<? extends T> source, T defaultValue) {
        super(source);
        this.defaultValue = Objects.requireNonNull(defaultValue, "defaultValue");
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super T> actual) {
        return new TakeLastOneSubscriber<T>(actual, this.defaultValue, true);
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return super.scanUnsafe(key);
    }

    static final class TakeLastOneSubscriber<T>
    extends Operators.MonoSubscriber<T, T> {
        final boolean mustEmit;
        final T defaultValue;
        Subscription s;

        TakeLastOneSubscriber(CoreSubscriber<? super T> actual, @Nullable T defaultValue, boolean mustEmit) {
            super(actual);
            this.defaultValue = defaultValue;
            this.mustEmit = mustEmit;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
                s.request(Long.MAX_VALUE);
            }
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            if (key == Scannable.Attr.RUN_STYLE) {
                return Scannable.Attr.RunStyle.SYNC;
            }
            return super.scanUnsafe(key);
        }

        @Override
        public void onNext(T t) {
            Object old = this.value;
            this.setValue(t);
            Operators.onDiscard(old, this.actual.currentContext());
        }

        @Override
        public void onComplete() {
            Object v = this.value;
            if (v == null) {
                if (this.mustEmit) {
                    if (this.defaultValue != null) {
                        this.complete(this.defaultValue);
                    } else {
                        this.actual.onError(Operators.onOperatorError(new NoSuchElementException("Flux#last() didn't observe any onNext signal"), this.actual.currentContext()));
                    }
                } else {
                    this.actual.onComplete();
                }
                return;
            }
            this.complete(v);
        }

        @Override
        public void cancel() {
            super.cancel();
            this.s.cancel();
        }
    }
}

