/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.worldcomment.reactor.core.publisher;

import java.util.Objects;
import java.util.function.Function;
import vendor.cn.zbx1425.worldcomment.org.reactivestreams.Publisher;
import vendor.cn.zbx1425.worldcomment.reactor.core.CoreSubscriber;
import vendor.cn.zbx1425.worldcomment.reactor.core.Scannable;
import vendor.cn.zbx1425.worldcomment.reactor.core.publisher.Flux;
import vendor.cn.zbx1425.worldcomment.reactor.core.publisher.FluxTimeout;
import vendor.cn.zbx1425.worldcomment.reactor.core.publisher.InternalMonoOperator;
import vendor.cn.zbx1425.worldcomment.reactor.core.publisher.Mono;
import vendor.cn.zbx1425.worldcomment.reactor.core.publisher.Operators;

final class MonoTimeout<T, U, V>
extends InternalMonoOperator<T, T> {
    final Publisher<U> firstTimeout;
    final Publisher<? extends T> other;
    final String timeoutDescription;
    static final Function NEVER = e -> Flux.never();

    MonoTimeout(Mono<? extends T> source, Publisher<U> firstTimeout, String timeoutDescription) {
        super(source);
        this.firstTimeout = Objects.requireNonNull(firstTimeout, "firstTimeout");
        this.other = null;
        this.timeoutDescription = timeoutDescription;
    }

    MonoTimeout(Mono<? extends T> source, Publisher<U> firstTimeout, Publisher<? extends T> other) {
        super(source);
        this.firstTimeout = Objects.requireNonNull(firstTimeout, "firstTimeout");
        this.other = Objects.requireNonNull(other, "other");
        this.timeoutDescription = null;
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super T> actual) {
        return new FluxTimeout.TimeoutMainSubscriber(Operators.serialize(actual), this.firstTimeout, NEVER, this.other, FluxTimeout.addNameToTimeoutDescription(this.source, this.timeoutDescription));
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return super.scanUnsafe(key);
    }
}

