/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.worldcomment.reactor.core.publisher;

import vendor.cn.zbx1425.worldcomment.org.reactivestreams.Publisher;
import vendor.cn.zbx1425.worldcomment.reactor.core.CoreSubscriber;
import vendor.cn.zbx1425.worldcomment.reactor.core.Scannable;
import vendor.cn.zbx1425.worldcomment.reactor.core.publisher.Flux;
import vendor.cn.zbx1425.worldcomment.reactor.core.publisher.ParallelFlux;
import vendor.cn.zbx1425.worldcomment.reactor.core.publisher.SourceProducer;

final class ParallelArraySource<T>
extends ParallelFlux<T>
implements SourceProducer<T> {
    final Publisher<T>[] sources;

    ParallelArraySource(Publisher<T>[] sources) {
        if (sources == null || sources.length == 0) {
            throw new IllegalArgumentException("Zero publishers not supported");
        }
        this.sources = sources;
    }

    @Override
    public int parallelism() {
        return this.sources.length;
    }

    @Override
    public void subscribe(CoreSubscriber<? super T>[] subscribers) {
        if (!this.validate(subscribers)) {
            return;
        }
        int n = subscribers.length;
        for (int i = 0; i < n; ++i) {
            Flux.from(this.sources[i]).subscribe(subscribers[i]);
        }
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return SourceProducer.super.scanUnsafe(key);
    }
}

