/*
 * Decompiled with CFR 0.152.
 */
package top.mcmtr.mixin;

import org.mtr.libraries.com.logisticscraft.occlusionculling.util.Vec3d;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.ClientWorld;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.LightType;
import org.mtr.mapping.holder.LightmapTextureManager;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mod.Init;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.RenderRails;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import top.mcmtr.core.data.Catenary;
import top.mcmtr.core.data.RigidCatenary;
import top.mcmtr.mod.client.MSDMinecraftClientData;

@Mixin(value={RenderRails.class})
public abstract class RenderRailsMixin {
    @Unique
    private static final Identifier CATENARY_TEXTURE = new Identifier("msd", "textures/block/overhead_line.png");
    @Unique
    private static final Identifier RIGID_CATENARY_TEXTURE = new Identifier("msd", "textures/block/rigid_overhead_line.png");

    @Inject(method={"render"}, at={@At(value="HEAD")}, remap=false)
    private static void renderCatenary(CallbackInfo ci) {
        MinecraftClient minecraftClientMSD = MinecraftClient.getInstance();
        ClientWorld clientWorldMSD = minecraftClientMSD.getWorldMapped();
        ClientPlayerEntity clientPlayerEntityMSD = minecraftClientMSD.getPlayerMapped();
        if (clientWorldMSD == null || clientPlayerEntityMSD == null) {
            return;
        }
        ObjectArrayList cullingTasksMSD = new ObjectArrayList();
        Vector3d cameraPositionMSD = minecraftClientMSD.getGameRendererMapped().getCamera().getPos();
        Vec3d cameraMSD = new Vec3d(cameraPositionMSD.getXMapped(), cameraPositionMSD.getYMapped(), cameraPositionMSD.getZMapped());
        ObjectArrayList catenariesToRender = new ObjectArrayList();
        MSDMinecraftClientData.getInstance().catenaryWrapperList.values().forEach(catenaryWrapper -> {
            cullingTasksMSD.add(occlusionCullingInstance -> {
                boolean shouldRender = occlusionCullingInstance.isAABBVisible(catenaryWrapper.startVector, catenaryWrapper.endVector, cameraMSD);
                return () -> {
                    catenaryWrapper.shouldRender = shouldRender;
                };
            });
            if (catenaryWrapper.shouldRender) {
                catenariesToRender.add((Object)catenaryWrapper.getCatenary());
            }
        });
        ObjectArrayList rigidCatenariesToRender = new ObjectArrayList();
        MSDMinecraftClientData.getInstance().rigidCatenaryWrapperList.values().forEach(rigidCatenaryWrapper -> {
            cullingTasksMSD.add(occlusionCullingInstance -> {
                boolean shouldRender = occlusionCullingInstance.isAABBVisible(rigidCatenaryWrapper.startVector, rigidCatenaryWrapper.endVector, cameraMSD);
                return () -> {
                    rigidCatenaryWrapper.shouldRender = shouldRender;
                };
            });
            if (rigidCatenaryWrapper.shouldRender) {
                rigidCatenariesToRender.add((Object)rigidCatenaryWrapper.getRigidCatenary());
            }
        });
        catenariesToRender.forEach(catenary -> {
            switch (catenary.getCatenaryType()) {
                case CATENARY: {
                    RenderRailsMixin.renderCatenaryStandard(clientWorldMSD, catenary);
                    break;
                }
                case ELECTRIC: {
                    MainRenderer.scheduleRender((QueuedRenderLayer)QueuedRenderLayer.LINES, (graphicsHolder, offset) -> catenary.catenaryMath.render((x1, y1, z1, x2, y2, z2, count, i, base, sinX, sinZ, increment) -> graphicsHolder.drawLineInWorld((float)(x1 - offset.getXMapped()), (float)(y1 - offset.getYMapped() + 0.5), (float)(z1 - offset.getZMapped()), (float)(x2 - offset.getXMapped()), (float)(y2 - offset.getYMapped() + 0.5), (float)(z2 - offset.getZMapped()), -16777216)));
                    break;
                }
                case RIGID_SOFT_CATENARY: {
                    RenderRailsMixin.renderRigidSoftCatenaryStandard(clientWorldMSD, catenary);
                }
            }
        });
        rigidCatenariesToRender.forEach(rigidCatenary -> RenderRailsMixin.renderRigidCatenaryStandard(clientWorldMSD, rigidCatenary));
        MainRenderer.WORKER_THREAD.scheduleRails(occlusionCullingInstance -> {
            ObjectArrayList tasks = new ObjectArrayList();
            cullingTasksMSD.forEach(occlusionCullingInstanceRunnableFunction -> tasks.add((Object)((Runnable)occlusionCullingInstanceRunnableFunction.apply(occlusionCullingInstance))));
            minecraftClientMSD.execute(() -> tasks.forEach(Runnable::run));
        });
    }

    @Unique
    private static void renderCatenaryStandard(ClientWorld clientWorld, Catenary catenary) {
        catenary.catenaryMath.render((x1, y1, z1, x2, y2, z2, count, i, base, sinX, sinZ, increment) -> {
            BlockPos blockPos = Init.newBlockPos((double)x1, (double)y1, (double)z1);
            int light = LightmapTextureManager.pack((int)clientWorld.getLightLevel(LightType.getBlockMapped(), blockPos), (int)clientWorld.getLightLevel(LightType.getSkyMapped(), blockPos));
            MainRenderer.scheduleRender((Identifier)CATENARY_TEXTURE, (boolean)false, (QueuedRenderLayer)QueuedRenderLayer.EXTERIOR, (graphicsHolder, offset) -> {
                if (count < 8.0) {
                    IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (double)x1, (double)(y1 + (double)0.65f + base), (double)z1, (double)x2, (double)(y2 + (double)0.65f + base), (double)z2, (double)x2, (double)y2, (double)z2, (double)x1, (double)y1, (double)z1, (Vector3d)offset, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (Direction)Direction.UP, (int)-1, (int)light);
                    IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (double)x2, (double)(y2 + (double)0.65f + base), (double)z2, (double)x1, (double)(y1 + (double)0.65f + base), (double)z1, (double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2, (Vector3d)offset, (float)0.0f, (float)1.0f, (float)1.0f, (float)0.0f, (Direction)Direction.UP, (int)-1, (int)light);
                } else if (i < count / 2.0 - increment) {
                    IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (double)x1, (double)(y1 + (double)0.65f + base), (double)z1, (double)x2, (double)(y2 + (double)0.65f + base * 0.5), (double)z2, (double)x2, (double)y2, (double)z2, (double)x1, (double)y1, (double)z1, (Vector3d)offset, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (Direction)Direction.UP, (int)-1, (int)light);
                    IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (double)x2, (double)(y2 + (double)0.65f + base * 0.5), (double)z2, (double)x1, (double)(y1 + (double)0.65f + base), (double)z1, (double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2, (Vector3d)offset, (float)0.0f, (float)1.0f, (float)1.0f, (float)0.0f, (Direction)Direction.UP, (int)-1, (int)light);
                } else if (i >= count / 2.0) {
                    IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (double)x1, (double)(y1 + (double)0.65f + base), (double)z1, (double)x2, (double)(y2 + (double)0.65f + base / 0.5), (double)z2, (double)x2, (double)y2, (double)z2, (double)x1, (double)y1, (double)z1, (Vector3d)offset, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (Direction)Direction.UP, (int)-1, (int)light);
                    IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (double)x2, (double)(y2 + (double)0.65f + base / 0.5), (double)z2, (double)x1, (double)(y1 + (double)0.65f + base), (double)z1, (double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2, (Vector3d)offset, (float)0.0f, (float)1.0f, (float)1.0f, (float)0.0f, (Direction)Direction.UP, (int)-1, (int)light);
                } else {
                    IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (double)x1, (double)(y1 + (double)0.65f + base), (double)z1, (double)x2, (double)(y2 + (double)0.65f + base), (double)z2, (double)x2, (double)y2, (double)z2, (double)x1, (double)y1, (double)z1, (Vector3d)offset, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (Direction)Direction.UP, (int)-1, (int)light);
                    IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (double)x2, (double)(y2 + (double)0.65f + base), (double)z2, (double)x1, (double)(y1 + (double)0.65f + base), (double)z1, (double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2, (Vector3d)offset, (float)0.0f, (float)1.0f, (float)1.0f, (float)0.0f, (Direction)Direction.UP, (int)-1, (int)light);
                }
                IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (double)(x1 - sinX), (double)y1, (double)(z1 + sinZ), (double)(x2 - sinX), (double)y2, (double)(z2 + sinZ), (double)(x2 + sinX), (double)y2, (double)(z2 - sinZ), (double)(x1 + sinX), (double)y1, (double)(z1 - sinZ), (Vector3d)offset, (float)0.0f, (float)0.0f, (float)1.0f, (float)0.03125f, (Direction)Direction.UP, (int)-1, (int)light);
                IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (double)(x2 - sinX), (double)y2, (double)(z2 + sinZ), (double)(x1 - sinX), (double)y1, (double)(z1 + sinZ), (double)(x1 + sinX), (double)y1, (double)(z1 - sinZ), (double)(x2 + sinX), (double)y2, (double)(z2 - sinZ), (Vector3d)offset, (float)0.0f, (float)0.03125f, (float)1.0f, (float)0.0f, (Direction)Direction.UP, (int)-1, (int)light);
            });
        });
    }

    @Unique
    private static void renderRigidCatenaryStandard(ClientWorld clientWorld, RigidCatenary rigidCatenary) {
        rigidCatenary.rigidCatenaryMath.render((x1, z1, x2, z2, x3, z3, x4, z4, x5, z5, x6, z6, x7, z7, x8, z8, y1, y2) -> {
            BlockPos blockPos = Init.newBlockPos((double)x1, (double)y1, (double)z1);
            int light = LightmapTextureManager.pack((int)clientWorld.getLightLevel(LightType.getBlockMapped(), blockPos), (int)clientWorld.getLightLevel(LightType.getSkyMapped(), blockPos));
            MainRenderer.scheduleRender((Identifier)RIGID_CATENARY_TEXTURE, (boolean)false, (QueuedRenderLayer)QueuedRenderLayer.EXTERIOR, (graphicsHolder, offset) -> {
                IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (double)x1, (double)y1, (double)z1, (double)x2, (double)y1, (double)z2, (double)x3, (double)y2, (double)z3, (double)x4, (double)y2, (double)z4, (Vector3d)offset, (float)0.0f, (float)0.0f, (float)1.0f, (float)0.03125f, (Direction)Direction.UP, (int)-1, (int)light);
                IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (double)x3, (double)y2, (double)z3, (double)x2, (double)y1, (double)z2, (double)x1, (double)y1, (double)z1, (double)x4, (double)y2, (double)z4, (Vector3d)offset, (float)0.0f, (float)0.03125f, (float)1.0f, (float)0.0f, (Direction)Direction.UP, (int)-1, (int)light);
                IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (double)x1, (double)y1, (double)z1, (double)x5, (double)(y1 + 0.125), (double)z5, (double)x8, (double)(y2 + 0.125), (double)z8, (double)x4, (double)y2, (double)z4, (Vector3d)offset, (float)0.0f, (float)0.5f, (float)1.0f, (float)1.0f, (Direction)Direction.UP, (int)-1, (int)light);
                IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (double)x8, (double)(y2 + 0.125), (double)z8, (double)x5, (double)(y1 + 0.125), (double)z5, (double)x1, (double)y1, (double)z1, (double)x4, (double)y2, (double)z4, (Vector3d)offset, (float)0.0f, (float)1.0f, (float)1.0f, (float)0.5f, (Direction)Direction.UP, (int)-1, (int)light);
                IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (double)x2, (double)y1, (double)z2, (double)x6, (double)(y1 + 0.125), (double)z6, (double)x7, (double)(y2 + 0.125), (double)z7, (double)x3, (double)y2, (double)z3, (Vector3d)offset, (float)0.0f, (float)0.5f, (float)1.0f, (float)1.0f, (Direction)Direction.UP, (int)-1, (int)light);
                IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (double)x7, (double)(y2 + 0.125), (double)z7, (double)x6, (double)(y1 + 0.125), (double)z6, (double)x2, (double)y1, (double)z2, (double)x3, (double)y2, (double)z3, (Vector3d)offset, (float)0.0f, (float)1.0f, (float)1.0f, (float)0.5f, (Direction)Direction.UP, (int)-1, (int)light);
                IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (double)x5, (double)(y1 + 0.125), (double)z5, (double)x6, (double)(y1 + 0.125), (double)z6, (double)x7, (double)(y2 + 0.125), (double)z7, (double)x8, (double)(y2 + 0.125), (double)z8, (Vector3d)offset, (float)0.0f, (float)0.5f, (float)1.0f, (float)1.0f, (Direction)Direction.UP, (int)-1, (int)light);
                IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (double)x7, (double)(y2 + 0.125), (double)z7, (double)x6, (double)(y1 + 0.125), (double)z6, (double)x5, (double)(y1 + 0.125), (double)z5, (double)x8, (double)(y2 + 0.125), (double)z8, (Vector3d)offset, (float)0.0f, (float)1.0f, (float)1.0f, (float)0.5f, (Direction)Direction.UP, (int)-1, (int)light);
            });
        });
    }

    @Unique
    private static void renderRigidSoftCatenaryStandard(ClientWorld clientWorld, Catenary catenary) {
        catenary.catenaryMath.render((x1, y1, z1, x2, y2, z2, count, i, base, sinX, sinZ, increment) -> {
            BlockPos blockPos = Init.newBlockPos((double)x1, (double)y1, (double)z1);
            int light = LightmapTextureManager.pack((int)clientWorld.getLightLevel(LightType.getBlockMapped(), blockPos), (int)clientWorld.getLightLevel(LightType.getSkyMapped(), blockPos));
            MainRenderer.scheduleRender((Identifier)CATENARY_TEXTURE, (boolean)false, (QueuedRenderLayer)QueuedRenderLayer.EXTERIOR, (graphicsHolder, offset) -> {
                IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (double)(x1 - sinX), (double)y1, (double)(z1 + sinZ), (double)(x2 - sinX), (double)y2, (double)(z2 + sinZ), (double)(x2 + sinX), (double)y2, (double)(z2 - sinZ), (double)(x1 + sinX), (double)y1, (double)(z1 - sinZ), (Vector3d)offset, (float)0.0f, (float)0.0f, (float)1.0f, (float)0.03125f, (Direction)Direction.UP, (int)-1, (int)light);
                IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (double)(x2 - sinX), (double)y2, (double)(z2 + sinZ), (double)(x1 - sinX), (double)y1, (double)(z1 + sinZ), (double)(x1 + sinX), (double)y1, (double)(z1 - sinZ), (double)(x2 + sinX), (double)y2, (double)(z2 - sinZ), (Vector3d)offset, (float)0.0f, (float)0.03125f, (float)1.0f, (float)0.0f, (Direction)Direction.UP, (int)-1, (int)light);
                IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (double)x1, (double)(y1 + 0.03125), (double)z1, (double)x2, (double)(y2 + 0.03125), (double)z2, (double)x2, (double)y2, (double)z2, (double)x1, (double)y1, (double)z1, (Vector3d)offset, (float)0.0f, (float)0.0f, (float)1.0f, (float)0.03125f, (Direction)Direction.UP, (int)-1, (int)light);
                IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (double)x2, (double)(y2 + 0.03125), (double)z2, (double)x1, (double)(y1 + 0.03125), (double)z1, (double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2, (Vector3d)offset, (float)0.0f, (float)0.03125f, (float)1.0f, (float)0.0f, (Direction)Direction.UP, (int)-1, (int)light);
            });
        });
    }
}

