/*
 * Decompiled with CFR 0.152.
 */
package top.mcmtr.mod;

import java.io.File;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_1937;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mtr.core.serializer.SerializedDataBase;
import org.mtr.core.servlet.QueueObject;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MinecraftServer;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.holder.WorldSavePath;
import org.mtr.mapping.mapper.MinecraftServerHelper;
import org.mtr.mapping.registry.Registry;
import org.mtr.mod.config.Config;
import top.mcmtr.core.MSDMain;
import top.mcmtr.mod.BlockEntityTypes;
import top.mcmtr.mod.Blocks;
import top.mcmtr.mod.CreativeModeTabs;
import top.mcmtr.mod.Items;
import top.mcmtr.mod.packet.MSDPacketDeleteData;
import top.mcmtr.mod.packet.MSDPacketOpenBlockEntityScreen;
import top.mcmtr.mod.packet.MSDPacketOpenCatenaryScreen;
import top.mcmtr.mod.packet.MSDPacketOpenCatenaryWithModelScreen;
import top.mcmtr.mod.packet.MSDPacketOpenCustomScreen;
import top.mcmtr.mod.packet.MSDPacketRequestData;
import top.mcmtr.mod.packet.MSDPacketResetData;
import top.mcmtr.mod.packet.MSDPacketUpdateCatenaryNode;
import top.mcmtr.mod.packet.MSDPacketUpdateCustomText;
import top.mcmtr.mod.packet.MSDPacketUpdateData;
import top.mcmtr.mod.packet.MSDPacketUpdateModel;
import top.mcmtr.mod.packet.MSDPacketUpdateYamanoteRailwaySignConfig;

public class Init
implements Utilities {
    private static MSDMain main;
    private static long lastSavedMillis;
    public static final String MOD_ID = "msd";
    public static final Logger MSD_LOGGER;
    public static final Registry REGISTRY;
    private static final ObjectArrayList<String> WORLD_ID_LIST;
    public static final int AUTOSAVE_INTERVAL = 30000;

    public static void init() {
        Items.init();
        Blocks.init();
        BlockEntityTypes.init();
        CreativeModeTabs.init();
        REGISTRY.setupPackets(new Identifier(MOD_ID, "packet"));
        REGISTRY.registerPacket(MSDPacketDeleteData.class, MSDPacketDeleteData::new);
        REGISTRY.registerPacket(MSDPacketRequestData.class, MSDPacketRequestData::new);
        REGISTRY.registerPacket(MSDPacketUpdateData.class, MSDPacketUpdateData::new);
        REGISTRY.registerPacket(MSDPacketResetData.class, MSDPacketResetData::new);
        REGISTRY.registerPacket(MSDPacketOpenCatenaryScreen.class, MSDPacketOpenCatenaryScreen::new);
        REGISTRY.registerPacket(MSDPacketUpdateCatenaryNode.class, MSDPacketUpdateCatenaryNode::new);
        REGISTRY.registerPacket(MSDPacketUpdateYamanoteRailwaySignConfig.class, MSDPacketUpdateYamanoteRailwaySignConfig::new);
        REGISTRY.registerPacket(MSDPacketOpenBlockEntityScreen.class, MSDPacketOpenBlockEntityScreen::new);
        REGISTRY.registerPacket(MSDPacketOpenCustomScreen.class, MSDPacketOpenCustomScreen::new);
        REGISTRY.registerPacket(MSDPacketUpdateCustomText.class, MSDPacketUpdateCustomText::new);
        REGISTRY.registerPacket(MSDPacketUpdateModel.class, MSDPacketUpdateModel::new);
        REGISTRY.registerPacket(MSDPacketOpenCatenaryWithModelScreen.class, MSDPacketOpenCatenaryWithModelScreen::new);
        Init.REGISTRY.eventRegistry.registerServerStarted(minecraftServer -> {
            WORLD_ID_LIST.clear();
            MinecraftServerHelper.iterateWorlds((MinecraftServer)minecraftServer, serverWorld -> WORLD_ID_LIST.add((Object)Init.getWorldId(new World((class_1937)serverWorld.data))));
            lastSavedMillis = System.currentTimeMillis();
            Config.init((File)minecraftServer.getRunDirectory());
            main = new MSDMain(minecraftServer.getSavePath(WorldSavePath.getRootMapped()).resolve(MOD_ID), Config.getServer().getUseThreadedSimulation(), (String[])WORLD_ID_LIST.toArray((Object[])new String[0]));
        });
        Init.REGISTRY.eventRegistry.registerStartServerTick(() -> {
            if (main != null) {
                long currentMillis;
                if (!Config.getServer().getUseThreadedSimulation()) {
                    main.manualTick();
                }
                if ((currentMillis = System.currentTimeMillis()) - lastSavedMillis > 30000L) {
                    main.save();
                    lastSavedMillis = currentMillis;
                }
            }
        });
        Init.REGISTRY.eventRegistry.registerPlayerDisconnect((minecraftServer, serverPlayerEntity) -> {
            if (main != null) {
                main.save();
            }
        });
        Init.REGISTRY.eventRegistry.registerServerStopping(minecraftServer -> {
            if (main != null) {
                main.stop();
            }
        });
        REGISTRY.init();
    }

    public static <T extends SerializedDataBase> void sendMessageC2S(String key, @Nullable MinecraftServer minecraftServer, @Nullable World world, SerializedDataBase data, @Nullable Consumer<T> consumer, @Nullable Class<T> responseDataClass) {
        if (main != null) {
            main.sendMessageC2S(world == null ? null : Integer.valueOf(WORLD_ID_LIST.indexOf((Object)Init.getWorldId(world))), new QueueObject(key, data, consumer == null || minecraftServer == null ? null : responseData -> minecraftServer.execute(() -> consumer.accept(responseData)), responseDataClass));
        }
    }

    private static String getWorldId(World world) {
        Identifier identifier = MinecraftServerHelper.getWorldId((World)world);
        return String.format("%s/%s", identifier.getNamespace(), identifier.getPath());
    }

    public static void logException(Exception e, String message) {
        MSD_LOGGER.error(message, (Throwable)e);
    }

    static {
        MSD_LOGGER = LogManager.getLogger((String)"MTR-Station-Decoration");
        REGISTRY = new Registry();
        WORLD_ID_LIST = new ObjectArrayList();
    }
}

