/*
 * Decompiled with CFR 0.152.
 */
package top.mcmtr.mod.render;

import org.mtr.core.tool.Utilities;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.data.IGui;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;
import top.mcmtr.mod.blocks.BlockCustomTextBase;
import top.mcmtr.mod.config.Config;

public class RenderCustomText<T extends BlockCustomTextBase.BlockCustomTextEntity>
extends BlockEntityRenderer<T>
implements IGui,
Utilities {
    private final int maxArrivals;
    private final float scale;
    private final float fRowScale;
    private final float sRowScale;
    private final float rowSpacing;
    private final float startX;
    private final float startY;
    private final float startZ;
    private final float maxHeight;
    private final float maxWidth;
    private final boolean rotate90;
    private final int[] colors;

    public RenderCustomText(BlockEntityRenderer.Argument argument, int maxArrivals, float startX, float startY, float startZ, float maxHeight, float maxWidth, boolean rotate90, float textPadding, float fRowTextPadding, float sRowTextPadding, float rowSpacing, int ... colors) {
        super(argument);
        this.maxArrivals = maxArrivals;
        this.scale = (float)(160 * maxArrivals) / maxHeight * textPadding;
        this.fRowScale = (float)(160 * maxArrivals) / maxHeight * fRowTextPadding;
        this.sRowScale = (float)(160 * maxArrivals) / maxHeight * sRowTextPadding;
        this.startX = startX;
        this.startY = startY;
        this.startZ = startZ;
        this.maxHeight = maxHeight;
        this.maxWidth = maxWidth;
        this.rotate90 = rotate90;
        this.rowSpacing = rowSpacing;
        this.colors = new int[maxArrivals];
        System.arraycopy(colors, 0, this.colors, 0, Math.min(colors.length, maxArrivals));
        if (colors.length < maxArrivals) {
            for (int i = colors.length; i < maxArrivals; ++i) {
                this.colors[i] = colors[colors.length - 1];
            }
        }
    }

    public void render(T entity, float tickDelta, GraphicsHolder ignored, int light, int overlay) {
        World world = entity.getWorld2();
        if (world == null) {
            return;
        }
        BlockPos blockPos = entity.getPos2();
        Direction facing = IBlock.getStatePropertySafe((World)world, (BlockPos)blockPos, (DirectionProperty)BlockCustomTextBase.FACING);
        MainRenderer.scheduleRender((QueuedRenderLayer)QueuedRenderLayer.TEXT, (graphicsHolder, offset) -> {
            this.render(entity, (GraphicsHolder)graphicsHolder, blockPos, (Vector3d)offset, facing, false);
            this.render(entity, (GraphicsHolder)graphicsHolder, blockPos.offset(facing), (Vector3d)offset, facing.getOpposite(), true);
        });
    }

    private void render(T entity, GraphicsHolder graphicsHolder, BlockPos blockPos, Vector3d offset, Direction facing, boolean rightAlign) {
        for (int i = 0; i < this.maxArrivals; ++i) {
            String[] text = ((BlockCustomTextBase.BlockCustomTextEntity)((Object)entity)).getMessage(i).split("\\|");
            String bigText = text[0];
            String smallText = null;
            float finalBigScale = this.scale;
            float finalSmallScale = 0.0f;
            if (text.length > 1) {
                smallText = text[text.length - 1];
                finalBigScale = this.fRowScale;
                finalSmallScale = this.sRowScale;
            }
            graphicsHolder.push();
            graphicsHolder.translate((double)blockPos.getX() - offset.getXMapped() + 0.5, (double)blockPos.getY() - offset.getYMapped(), (double)blockPos.getZ() - offset.getZMapped() + 0.5);
            graphicsHolder.rotateYDegrees((float)(this.rotate90 ? 90 : 0) - facing.asRotation());
            graphicsHolder.rotateZDegrees(180.0f);
            graphicsHolder.translate(rightAlign ? (double)((13.0f - this.startX) / 16.0f) : (double)((this.startX - 8.0f) / 16.0f), (double)(-this.startY / 16.0f + (float)i * this.maxHeight / (float)this.maxArrivals / 16.0f), (double)((this.startZ - 8.0f) / 16.0f - 0.00625f));
            RenderCustomText.renderText(graphicsHolder, bigText, this.colors[i], this.maxWidth * finalBigScale / 16.0f, 0.0, finalBigScale, rightAlign);
            if (smallText != null) {
                RenderCustomText.renderText(graphicsHolder, smallText, this.colors[i], this.maxWidth * finalSmallScale / 16.0f, 8.0f / finalBigScale + this.rowSpacing, finalSmallScale, rightAlign);
            }
            graphicsHolder.pop();
        }
    }

    private static void renderText(GraphicsHolder graphicsHolder, String text, int color, float maxWidth, double y, float scale, boolean rightAlign) {
        graphicsHolder.push();
        graphicsHolder.translate(0.0, y, 0.0);
        graphicsHolder.scale(1.0f / scale, 1.0f / scale, 1.0f / scale);
        int textWidth = GraphicsHolder.getTextWidth((String)text);
        if ((float)textWidth > maxWidth) {
            graphicsHolder.scale(maxWidth / (float)textWidth, 1.0f, 1.0f);
        }
        graphicsHolder.drawText(text, rightAlign ? Math.max(0, (int)maxWidth - textWidth) : 0, 0, color | 0xFF000000, false, GraphicsHolder.getDefaultLight());
        graphicsHolder.pop();
    }

    public int getRenderDistance2() {
        return Config.getCustomTextSignMaxViewDistance();
    }
}

