/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client;

import games.alejandrocoria.mapfrontiers.MapFrontiers;
import games.alejandrocoria.mapfrontiers.client.FrontierOverlay;
import games.alejandrocoria.mapfrontiers.client.FrontiersOverlayManager;
import games.alejandrocoria.mapfrontiers.client.event.ClientEventHandler;
import games.alejandrocoria.mapfrontiers.client.gui.hud.HUD;
import games.alejandrocoria.mapfrontiers.client.gui.screen.ModSettings;
import games.alejandrocoria.mapfrontiers.common.Config;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import games.alejandrocoria.mapfrontiers.common.network.PacketHandler;
import games.alejandrocoria.mapfrontiers.common.network.PacketHandshake;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsProfile;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.client.api.IClientAPI;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import org.apache.commons.lang3.StringUtils;

@ParametersAreNonnullByDefault
public class MapFrontiersClient {
    private static IClientAPI jmAPI;
    private static boolean handshakeSended;
    private static FrontiersOverlayManager frontiersOverlayManager;
    private static FrontiersOverlayManager personalFrontiersOverlayManager;
    private static SettingsProfile settingsProfile;
    private static ModSettings.Tab lastSettingsTab;
    protected static class_304 openSettingsKey;
    private static HUD hud;
    private static class_2338 lastPlayerPosition;
    private static final Set<FrontierOverlay> insideFrontiers;
    private static FrontierData clipboard;

    protected static void init() {
        ClientEventHandler.subscribeUpdatedSettingsProfileEvent(MapFrontiersClient.class, profile -> {
            settingsProfile = profile;
        });
        ClientEventHandler.subscribeClientTickEvent(MapFrontiersClient.class, client -> {
            if (client.field_1687 == null) {
                return;
            }
            if (!handshakeSended) {
                handshakeSended = true;
                PacketHandler.sendToServer(new PacketHandshake());
            }
            if (frontiersOverlayManager != null) {
                frontiersOverlayManager.updateAllOverlays(false);
                personalFrontiersOverlayManager.updateAllOverlays(false);
            }
            if (hud != null) {
                hud.tick();
            }
        });
        ClientEventHandler.subscribePlayerTickEvent(MapFrontiersClient.class, (client, player) -> {
            if (client.field_1687 == null) {
                return;
            }
            if (frontiersOverlayManager == null) {
                return;
            }
            while (openSettingsKey.method_1436()) {
                client.method_1507((class_437)new ModSettings(null, false));
            }
            if (player == null) {
                return;
            }
            class_2338 currentPlayerPosition = player.method_24515();
            if (currentPlayerPosition.method_10263() != lastPlayerPosition.method_10263() || currentPlayerPosition.method_10260() != lastPlayerPosition.method_10260()) {
                lastPlayerPosition = currentPlayerPosition;
                Set<FrontierOverlay> frontiers = personalFrontiersOverlayManager.getFrontiersForAnnounce((class_5321<class_1937>)player.method_37908().method_27983(), lastPlayerPosition);
                frontiers.addAll(frontiersOverlayManager.getFrontiersForAnnounce((class_5321<class_1937>)player.method_37908().method_27983(), lastPlayerPosition));
                Iterator<FrontierOverlay> i = insideFrontiers.iterator();
                while (i.hasNext()) {
                    FrontierOverlay inside = i.next();
                    if (!frontiers.stream().noneMatch(f -> f.getId().equals(inside.getId()))) continue;
                    if (inside.getAnnounceInChat() && (inside.isNamed() || Config.announceUnnamedFrontiers)) {
                        player.method_7353((class_2561)class_2561.method_43469((String)"mapfrontiers.chat.leaving", (Object[])new Object[]{MapFrontiersClient.createAnnounceTextWithName(inside)}), false);
                    }
                    i.remove();
                }
                for (FrontierOverlay frontier : frontiers) {
                    if (!insideFrontiers.add(frontier) || !frontier.isNamed() && !Config.announceUnnamedFrontiers) continue;
                    class_2561 text = MapFrontiersClient.createAnnounceTextWithName(frontier);
                    if (frontier.getAnnounceInChat()) {
                        player.method_7353((class_2561)class_2561.method_43469((String)"mapfrontiers.chat.entering", (Object[])new Object[]{text}), false);
                    }
                    if (!frontier.getAnnounceInTitle()) continue;
                    if (Config.titleAnnouncementAboveHotbar) {
                        client.field_1705.method_1758(text, false);
                        continue;
                    }
                    client.field_1705.method_34004(text);
                }
            }
        });
        ClientEventHandler.subscribeHudRenderEvent(MapFrontiersClient.class, (graphics, delta) -> {
            if (hud != null) {
                hud.drawInGameHUD((class_332)graphics, delta.floatValue());
            }
        });
        ClientEventHandler.subscribeClientConnectedEvent(MapFrontiersClient.class, () -> {
            MapFrontiersClient.initializeManagers();
            hud = new HUD(frontiersOverlayManager, personalFrontiersOverlayManager);
            MapFrontiers.LOGGER.info("ClientConnectedEvent done");
        });
        ClientEventHandler.subscribeClientDisconnectedEvent(MapFrontiersClient.class, () -> {
            if (frontiersOverlayManager != null) {
                frontiersOverlayManager.close();
                frontiersOverlayManager = null;
                personalFrontiersOverlayManager.close();
                personalFrontiersOverlayManager = null;
            }
            if (hud != null) {
                hud = null;
            }
            settingsProfile = null;
            handshakeSended = false;
            MapFrontiers.LOGGER.info("ClientDisconnectedEvent done");
        });
    }

    private static class_2561 createAnnounceTextWithName(FrontierOverlay frontier) {
        if (!frontier.isNamed()) {
            class_5250 text = class_2561.method_43469((String)"mapfrontiers.unnamed", (Object[])new Object[]{class_124.field_1056});
            text.method_27694(style -> style.method_10978(Boolean.valueOf(true)).method_36139(0xAAAAAA));
            return text;
        }
        Object name = frontier.getName1().trim();
        String name2 = frontier.getName2().trim();
        if (!StringUtils.isBlank((CharSequence)name2)) {
            if (!((String)name).isEmpty()) {
                name = (String)name + " ";
            }
            name = (String)name + name2;
        }
        class_5250 text = class_2561.method_43470((String)name);
        text.method_27694(style -> style.method_36139(frontier.getColor()));
        return text;
    }

    public static void setjmAPI(IClientAPI newJmAPI) {
        jmAPI = newJmAPI;
    }

    private static void initializeManagers() {
        if (jmAPI == null) {
            return;
        }
        if (frontiersOverlayManager == null) {
            frontiersOverlayManager = new FrontiersOverlayManager(jmAPI, false);
        }
        if (personalFrontiersOverlayManager == null) {
            personalFrontiersOverlayManager = new FrontiersOverlayManager(jmAPI, true);
        }
    }

    public static void setFrontiersFromServer(List<FrontierData> globalFrontiers, List<FrontierData> personalFrontiers) {
        MapFrontiersClient.initializeManagers();
        frontiersOverlayManager.setFrontiersFromServer(globalFrontiers);
        personalFrontiersOverlayManager.setFrontiersFromServer(personalFrontiers);
        if (hud != null) {
            hud.frontierChanged();
        }
    }

    public static FrontiersOverlayManager getFrontiersOverlayManager(boolean personal) {
        MapFrontiersClient.initializeManagers();
        if (personal) {
            return personalFrontiersOverlayManager;
        }
        return frontiersOverlayManager;
    }

    public static SettingsProfile getSettingsProfile() {
        return settingsProfile;
    }

    public static void setLastSettingsTab(ModSettings.Tab tab) {
        lastSettingsTab = tab;
    }

    public static ModSettings.Tab getLastSettingsTab() {
        return lastSettingsTab;
    }

    public static class_2561 getOpenSettingsKey() {
        if (openSettingsKey.method_1415()) {
            return null;
        }
        return openSettingsKey.method_16007();
    }

    public static boolean isModOnServer() {
        return settingsProfile != null;
    }

    public static void setClipboard(FrontierData newClipboard) {
        clipboard = new FrontierData(newClipboard);
    }

    public static FrontierData getClipboard() {
        return clipboard;
    }

    static {
        handshakeSended = false;
        lastSettingsTab = ModSettings.Tab.Credits;
        lastPlayerPosition = new class_2338(0, 0, 0);
        insideFrontiers = new HashSet<FrontierOverlay>();
        clipboard = null;
    }
}

