/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.component.scroll;

import games.alejandrocoria.mapfrontiers.client.gui.component.button.IconButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.scroll.ScrollBox;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUserShared;
import games.alejandrocoria.mapfrontiers.platform.Services;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4264;
import net.minecraft.class_437;

@ParametersAreNonnullByDefault
public class UserSharedElement
extends ScrollBox.ScrollElement {
    private final class_327 font;
    private final SettingsUserShared user;
    private final ActionChangedConsumer actionChangedCallback;
    private boolean updateFrontier;
    private boolean updateSettings;
    private IconButton buttonDelete;
    private final boolean enabled;
    private int pingBar = 0;
    private final class_437 screen;

    public UserSharedElement(class_327 font, class_437 screen, SettingsUserShared user, boolean enabled, boolean removable, ActionChangedConsumer actionChangedCallback) {
        super(430, 16);
        this.font = font;
        this.user = user;
        this.actionChangedCallback = actionChangedCallback;
        this.updateFrontier = user.hasAction(SettingsUserShared.Action.UpdateFrontier);
        this.updateSettings = user.hasAction(SettingsUserShared.Action.UpdateSettings);
        this.enabled = enabled;
        this.screen = screen;
        if (removable && enabled) {
            this.buttonDelete = new IconButton(0, 0, IconButton.Type.Remove, button -> {});
            Services.PLATFORM.addButtonToScreen((class_4264)this.buttonDelete, screen);
        }
    }

    @Override
    public void delete() {
        if (this.buttonDelete != null) {
            Services.PLATFORM.removeButtonOfScreen((class_4264)this.buttonDelete, this.screen);
        }
    }

    public SettingsUser getUser() {
        return this.user.getUser();
    }

    public void setPingBar(int value) {
        this.pingBar = value;
        if (this.pingBar < 0) {
            this.pingBar = 0;
        } else if (this.pingBar > 5) {
            this.pingBar = 5;
        }
    }

    @Override
    public void setX(int x) {
        super.setX(x);
        if (this.buttonDelete != null) {
            this.buttonDelete.method_46421(this.x + 413);
        }
    }

    @Override
    public void setY(int y) {
        super.setY(y);
        if (this.buttonDelete != null) {
            this.buttonDelete.method_46419(this.y + 1);
        }
    }

    @Override
    public void renderWidget(class_332 graphics, int mouseX, int mouseY, float partialTicks, boolean selected) {
        if (this.isHovered) {
            graphics.method_25294(this.x, this.y, this.x + this.width, this.y + this.height, -1608375774);
        }
        if (this.buttonDelete != null) {
            this.buttonDelete.field_22764 = this.isHovered;
        }
        graphics.method_25303(this.font, this.user.getUser().toString(), this.x + 4, this.y + 4, -1);
        this.drawBox(graphics, this.x + 244, this.y + 2, this.updateFrontier);
        this.drawBox(graphics, this.x + 304, this.y + 2, this.updateSettings);
        if (this.user.isPending()) {
            graphics.method_25303(this.font, class_1074.method_4662((String)"mapfrontiers.pending", (Object[])new Object[]{class_124.field_1056}), this.x + 350, this.y + 4, -16720640);
        }
        if (this.pingBar > 0) {
            this.drawPingLine(graphics, this.x - 11, this.y + 11, 2);
        }
        if (this.pingBar > 1) {
            this.drawPingLine(graphics, this.x - 9, this.y + 11, 3);
        }
        if (this.pingBar > 2) {
            this.drawPingLine(graphics, this.x - 7, this.y + 11, 4);
        }
        if (this.pingBar > 3) {
            this.drawPingLine(graphics, this.x - 5, this.y + 11, 5);
        }
        if (this.pingBar > 4) {
            this.drawPingLine(graphics, this.x - 3, this.y + 11, 6);
        }
    }

    private void drawPingLine(class_332 graphics, int posX, int posY, int height) {
        graphics.method_25294(posX, posY - height, posX + 1, posY, -1);
    }

    @Override
    public ScrollBox.ScrollElement.Action mousePressed(double mouseX, double mouseY) {
        if (this.enabled && this.visible && this.isHovered && this.actionChangedCallback != null) {
            if (mouseX >= (double)(this.x + 220) && mouseX <= (double)(this.x + 280)) {
                this.updateFrontier = !this.updateFrontier;
                this.actionChangedCallback.accept(this.user, SettingsUserShared.Action.UpdateFrontier, this.updateFrontier);
            } else if (mouseX >= (double)(this.x + 280) && mouseX <= (double)(this.x + 340)) {
                this.updateSettings = !this.updateSettings;
                this.actionChangedCallback.accept(this.user, SettingsUserShared.Action.UpdateSettings, this.updateSettings);
            }
        }
        if (this.enabled && this.visible && this.isHovered && this.buttonDelete != null && this.buttonDelete.method_25405(mouseX, mouseY)) {
            return ScrollBox.ScrollElement.Action.Deleted;
        }
        return ScrollBox.ScrollElement.Action.None;
    }

    private void drawBox(class_332 graphics, int x, int y, boolean checked) {
        graphics.method_25294(x, y, x + 12, y + 12, -12303292);
        graphics.method_25294(x + 1, y + 1, x + 11, y + 11, -16777216);
        if (checked) {
            graphics.method_25294(x + 2, y + 2, x + 10, y + 10, -10066330);
        }
    }

    @FunctionalInterface
    public static interface ActionChangedConsumer {
        public void accept(SettingsUserShared var1, SettingsUserShared.Action var2, boolean var3);
    }
}

