/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.common.settings;

import games.alejandrocoria.mapfrontiers.MapFrontiers;
import games.alejandrocoria.mapfrontiers.common.settings.FrontierSettings;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import games.alejandrocoria.mapfrontiers.common.util.StringHelper;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;

@ParametersAreNonnullByDefault
public class SettingsGroup {
    private String name;
    private List<SettingsUser> users;
    private final Set<FrontierSettings.Action> actions;
    private final boolean special;

    public SettingsGroup() {
        this.name = "";
        this.users = new ArrayList<SettingsUser>();
        this.actions = EnumSet.noneOf(FrontierSettings.Action.class);
        this.special = false;
    }

    public SettingsGroup(String name, boolean special) {
        this.name = name;
        this.users = new ArrayList<SettingsUser>();
        this.actions = EnumSet.noneOf(FrontierSettings.Action.class);
        this.special = special;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addAction(FrontierSettings.Action action) {
        this.actions.add(action);
    }

    public List<SettingsUser> getUsers() {
        return this.users;
    }

    public void removeAction(FrontierSettings.Action action) {
        this.actions.remove((Object)action);
    }

    public boolean hasAction(FrontierSettings.Action action) {
        return this.actions.contains((Object)action);
    }

    public Set<FrontierSettings.Action> getActions() {
        return this.actions;
    }

    public void addUser(SettingsUser user) {
        this.users.add(user);
    }

    public void removeUser(SettingsUser user) {
        this.users.remove(user);
    }

    public boolean hasUser(SettingsUser user) {
        return this.users.contains(user);
    }

    public boolean isSpecial() {
        return this.special;
    }

    public void readFromNBT(class_2487 nbt, int version) {
        int i;
        if (!this.special) {
            this.name = nbt.method_10558("name");
            this.users.clear();
            class_2499 usersTagList = nbt.method_10554("users", 10);
            for (i = 0; i < usersTagList.size(); ++i) {
                SettingsUser user = new SettingsUser();
                class_2487 userTag = usersTagList.method_10602(i);
                user.readFromNBT(userTag);
                this.users.add(user);
            }
        }
        this.actions.clear();
        class_2499 actionsTagList = nbt.method_10554("actions", 8);
        for (i = 0; i < actionsTagList.size(); ++i) {
            String actionTag = actionsTagList.method_10608(i);
            List<FrontierSettings.Action> availableActions = FrontierSettings.getAvailableActions(this.name);
            try {
                FrontierSettings.Action action = version > 3 ? FrontierSettings.Action.valueOf(actionTag) : FrontierSettings.ActionV3.valueOf(actionTag).toAction();
                if (!availableActions.contains((Object)action)) {
                    throw new IllegalArgumentException();
                }
                this.actions.add(action);
                continue;
            }
            catch (IllegalArgumentException e) {
                String availableActionsString = version > 3 ? StringHelper.enumValuesToString(availableActions) : StringHelper.enumValuesToString(FrontierSettings.getAvailableActionsV3(this.name));
                MapFrontiers.LOGGER.warn(String.format("Unknown action in group %1$s. Found: \"%2$s\". Expected: %3$s", this.name, actionTag, availableActionsString));
            }
        }
    }

    public void writeToNBT(class_2487 nbt) {
        if (!this.special) {
            nbt.method_10582("name", this.name);
            class_2499 usersTagList = new class_2499();
            for (SettingsUser user : this.users) {
                class_2487 userTag = new class_2487();
                user.writeToNBT(userTag);
                usersTagList.add((Object)userTag);
            }
            nbt.method_10566("users", (class_2520)usersTagList);
        }
        class_2499 actionsTagList = new class_2499();
        for (FrontierSettings.Action action : this.actions) {
            class_2519 actionTag = class_2519.method_23256((String)action.name());
            actionsTagList.add((Object)actionTag);
        }
        nbt.method_10566("actions", (class_2520)actionsTagList);
    }

    public void fromBytes(class_2540 buf) {
        if (!buf.readBoolean()) {
            this.name = buf.method_10800(17);
            this.users = new ArrayList<SettingsUser>();
            int usersCount = buf.readInt();
            for (int i = 0; i < usersCount; ++i) {
                SettingsUser user = new SettingsUser();
                user.fromBytes(buf);
                this.users.add(user);
            }
        }
        this.actions.clear();
        for (FrontierSettings.Action action : FrontierSettings.Action.valuesArray) {
            if (!buf.readBoolean()) continue;
            this.actions.add(action);
        }
    }

    public void toBytes(class_2540 buf) {
        buf.writeBoolean(this.special);
        if (!this.special) {
            buf.method_10788(this.name, 17);
            buf.writeInt(this.users.size());
            for (SettingsUser user : this.users) {
                user.toBytes(buf);
            }
        }
        for (FrontierSettings.Action action : FrontierSettings.Action.valuesArray) {
            buf.writeBoolean(this.actions.contains((Object)action));
        }
    }
}

