/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.platform;

import games.alejandrocoria.mapfrontiers.common.util.ReflectionHelper;
import games.alejandrocoria.mapfrontiers.platform.services.IJourneyMapHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import journeymap.client.data.WorldData;
import journeymap.client.io.FileHandler;
import journeymap.client.io.ThemeLoader;
import journeymap.client.properties.MiniMapProperties;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.minimap.DisplayVars;
import journeymap.client.ui.minimap.MiniMap;
import journeymap.client.ui.minimap.Position;
import journeymap.client.ui.minimap.Shape;
import journeymap.client.ui.theme.Theme;
import journeymap.client.waypoint.WaypointStore;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class FabricJourneyMapHelper
implements IJourneyMapHelper {
    private static boolean minimapPropertiesInitialized = false;
    private static boolean minimapEnabled;
    private static int minimapSize;
    private static Shape minimapShape;
    private static Position minimapPosition;
    private static String minimapInfo1;
    private static String minimapInfo2;
    private static String minimapInfo3;
    private static String minimapInfo4;
    private static int minimapFontScale;
    private static int minimapCompassFontScale;

    @Override
    public File getJMWorldDir(class_310 client) {
        return FileHandler.getJMWorldDir((class_310)client);
    }

    @Override
    public void fullscreenMapCenterOn(int x, int z) {
        UIManager.INSTANCE.openFullscreenMap().centerOn((double)x, (double)z);
    }

    @Override
    public boolean isMinimapEnabled() {
        return UIManager.INSTANCE.isMiniMapEnabled();
    }

    @Override
    public void drawMinimapPreview(class_332 graphics) {
        UIManager.INSTANCE.getMiniMap().drawMap(graphics, true);
    }

    @Override
    public int getMinimapWidth() throws NoSuchFieldException, IllegalAccessException {
        return (Integer)ReflectionHelper.getPrivateField(FabricJourneyMapHelper.getDisplayVars(), "minimapWidth");
    }

    @Override
    public int getMinimapHeight() throws NoSuchFieldException, IllegalAccessException {
        return (Integer)ReflectionHelper.getPrivateField(FabricJourneyMapHelper.getDisplayVars(), "minimapHeight");
    }

    @Override
    public int getMinimapTranslateX() throws NoSuchFieldException, IllegalAccessException {
        return (Integer)ReflectionHelper.getPrivateField(FabricJourneyMapHelper.getDisplayVars(), "translateX");
    }

    @Override
    public int getMinimapTranslateY() throws NoSuchFieldException, IllegalAccessException {
        return (Integer)ReflectionHelper.getPrivateField(FabricJourneyMapHelper.getDisplayVars(), "translateY");
    }

    @Override
    public int getMinimapMargin() {
        Object minimapSpec = UIManager.INSTANCE.getMiniMap().getCurrentMinimapProperties().shape.get() == Shape.Circle ? ThemeLoader.getCurrentTheme().minimap.circle : ThemeLoader.getCurrentTheme().minimap.square;
        return minimapSpec.margin;
    }

    @Override
    public IJourneyMapHelper.JMPosition getMinimapPosition() {
        return switch ((Position)UIManager.INSTANCE.getMiniMap().getCurrentMinimapProperties().position.get()) {
            case Position.TopRight -> IJourneyMapHelper.JMPosition.TopRight;
            case Position.BottomRight -> IJourneyMapHelper.JMPosition.BottomRight;
            case Position.BottomLeft -> IJourneyMapHelper.JMPosition.BottomLeft;
            case Position.TopLeft -> IJourneyMapHelper.JMPosition.TopLeft;
            case Position.TopCenter -> IJourneyMapHelper.JMPosition.TopCenter;
            case Position.Center -> IJourneyMapHelper.JMPosition.Center;
            default -> IJourneyMapHelper.JMPosition.Custom;
        };
    }

    @Override
    public int getMinimapFontScale() {
        return UIManager.INSTANCE.getMiniMap().getCurrentMinimapProperties().fontScale.get().intValue();
    }

    @Override
    public int minimapLabelBackgroundColor() {
        if (UIManager.INSTANCE.getMiniMap().getCurrentMinimapProperties().shape.get() == Shape.Circle) {
            return FabricJourneyMapHelper.colorSpecToInt(ThemeLoader.getCurrentTheme().minimap.circle.labelTop.background);
        }
        return FabricJourneyMapHelper.colorSpecToInt(ThemeLoader.getCurrentTheme().minimap.square.labelTop.background);
    }

    @Override
    public int minimapLabelHighlightColor() {
        if (UIManager.INSTANCE.getMiniMap().getCurrentMinimapProperties().shape.get() == Shape.Circle) {
            return FabricJourneyMapHelper.colorSpecToInt(ThemeLoader.getCurrentTheme().minimap.circle.labelTop.highlight);
        }
        return FabricJourneyMapHelper.colorSpecToInt(ThemeLoader.getCurrentTheme().minimap.square.labelTop.highlight);
    }

    @Override
    public int minimapLabelForegroundColor() {
        if (UIManager.INSTANCE.getMiniMap().getCurrentMinimapProperties().shape.get() == Shape.Circle) {
            return FabricJourneyMapHelper.colorSpecToInt(ThemeLoader.getCurrentTheme().minimap.circle.labelTop.foreground);
        }
        return FabricJourneyMapHelper.colorSpecToInt(ThemeLoader.getCurrentTheme().minimap.square.labelTop.foreground);
    }

    @Override
    public boolean minimapPropertiesChanged() {
        if (!minimapPropertiesInitialized) {
            FabricJourneyMapHelper.setAllMinimapProperties();
            return true;
        }
        MiniMapProperties minimapProperties = UIManager.INSTANCE.getMiniMap().getCurrentMinimapProperties();
        if (minimapEnabled != minimapProperties.enabled.get() || minimapSize != minimapProperties.sizePercent.get() || minimapShape != minimapProperties.shape.get() || minimapPosition != minimapProperties.position.get() || minimapInfo1.equals(minimapProperties.info1Label.get()) || minimapInfo2.equals(minimapProperties.info2Label.get()) || minimapInfo3.equals(minimapProperties.info3Label.get()) || minimapInfo4.equals(minimapProperties.info4Label.get()) || minimapFontScale != minimapProperties.fontScale.get().intValue() || minimapCompassFontScale != minimapProperties.compassFontScale.get().intValue()) {
            FabricJourneyMapHelper.setAllMinimapProperties();
            return true;
        }
        return false;
    }

    @Override
    public List<String> getDimensionList() {
        ArrayList<String> list = new ArrayList<String>();
        List dimensionProviders = WorldData.getDimensionProviders((List)WaypointStore.INSTANCE.getLoadedDimensions());
        for (WorldData.DimensionProvider dimension : dimensionProviders) {
            list.add(dimension.getDimensionId());
        }
        return list;
    }

    private static int colorSpecToInt(Theme.ColorSpec colorSpec) {
        int color = colorSpec.getColor();
        return color |= Math.round(colorSpec.alpha * 255.0f) << 24;
    }

    private static DisplayVars getDisplayVars() throws NoSuchFieldException, IllegalAccessException {
        MiniMap minimap = UIManager.INSTANCE.getMiniMap();
        return (DisplayVars)ReflectionHelper.getPrivateField(minimap, "dv");
    }

    private static void setAllMinimapProperties() {
        MiniMapProperties minimapProperties = UIManager.INSTANCE.getMiniMap().getCurrentMinimapProperties();
        minimapEnabled = minimapProperties.enabled.get();
        minimapSize = minimapProperties.sizePercent.get();
        minimapShape = (Shape)minimapProperties.shape.get();
        minimapPosition = (Position)minimapProperties.position.get();
        minimapInfo1 = minimapProperties.info1Label.get();
        minimapInfo2 = minimapProperties.info2Label.get();
        minimapInfo3 = minimapProperties.info3Label.get();
        minimapInfo4 = minimapProperties.info4Label.get();
        minimapFontScale = minimapProperties.fontScale.get().intValue();
        minimapCompassFontScale = minimapProperties.compassFontScale.get().intValue();
        minimapPropertiesInitialized = true;
    }
}

