/*
 * Decompiled with CFR 0.152.
 */
package net.domixcze.domixscreatures.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class ModConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = Paths.get("config", "domixs-creatures.json");
    public boolean enableWaterStriderRiding = true;
    public boolean enableSleepParticles = true;
    public boolean enableFireSalamanderSmelting = true;
    public boolean enableFireSalamanderMagmaBallAttack = true;
    public boolean enableSpectralBatScreechAttack = true;
    public boolean enableCaterpillarTransformation = true;
    public boolean enablePorcupineQuillAttack = true;
    public boolean enableCoconutPositiveEffectRemoval = true;
    public boolean enableBeaverLogStripping = true;
    public boolean enableRaccoonStealing = true;
    public boolean enableCoconutNegativeEffectRemoval = true;
    public boolean enableCoconutBonkSound = false;
    public int hermitCrabDailyTradeLimit = 20;
    public static ModConfig INSTANCE = new ModConfig();

    public static void loadConfig() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try (FileReader reader = new FileReader(CONFIG_PATH.toFile());){
                INSTANCE = (ModConfig)GSON.fromJson((Reader)reader, ModConfig.class);
                if (INSTANCE == null) {
                    INSTANCE = new ModConfig();
                    ModConfig.saveConfig();
                }
            }
            catch (IOException e) {
                System.err.println("Failed to load config for Domix's Creatures: " + e.getMessage());
                INSTANCE = new ModConfig();
                ModConfig.saveConfig();
            }
        } else {
            ModConfig.saveConfig();
        }
    }

    public static void saveConfig() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            try (FileWriter writer = new FileWriter(CONFIG_PATH.toFile());){
                GSON.toJson((Object)INSTANCE, (Appendable)writer);
            }
        }
        catch (IOException e) {
            System.err.println("Failed to save config for Domix's Creatures: " + e.getMessage());
        }
    }
}

