/*
 * Decompiled with CFR 0.152.
 */
package net.domixcze.domixscreatures.entity.ai;

import java.util.HashSet;
import java.util.List;
import net.domixcze.domixscreatures.block.ModBlocks;
import net.domixcze.domixscreatures.config.ModConfig;
import net.domixcze.domixscreatures.effect.ModEffects;
import net.domixcze.domixscreatures.entity.custom.SpectralBatEntity;
import net.domixcze.domixscreatures.item.ModItems;
import net.domixcze.domixscreatures.particle.ModParticles;
import net.domixcze.domixscreatures.sound.ModSounds;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class ScreechAttackGoal
extends class_1352 {
    private final SpectralBatEntity bat;
    private static final double ATTACK_RANGE = 10.0;
    private final float DAMAGE = 6.0f;
    private static final double GLASS_CRACK_RADIUS = 8.0;
    private static final double GLASS_CRACK_CHANCE = 0.3;

    public ScreechAttackGoal(SpectralBatEntity bat) {
        this.bat = bat;
    }

    public boolean method_6264() {
        if (!ModConfig.INSTANCE.enableSpectralBatScreechAttack) {
            return false;
        }
        if (this.bat.isHanging()) {
            return false;
        }
        if (this.bat.method_6109()) {
            return false;
        }
        class_1309 target = this.bat.method_5968();
        return target != null && this.bat.getScreechCooldown() == 0 && this.bat.method_5858((class_1297)target) <= 100.0;
    }

    public void method_6269() {
        this.bat.setScreeching(true);
        this.bat.resetScreechCooldown();
        this.bat.resetScreechDuration();
        List players = this.bat.method_37908().method_8390(class_1657.class, this.bat.method_5829().method_1014(10.0), player -> true);
        for (class_1657 player2 : players) {
            float volume = this.isProtectedFromScreech(player2) ? 0.05f : 1.0f;
            this.bat.method_37908().method_43128(null, player2.method_23317(), player2.method_23318(), player2.method_23321(), ModSounds.SPECTRAL_BAT_SCREECH, class_3419.field_15251, volume, 1.0f);
        }
        this.spawnScreech();
        this.applyEffect();
        this.crackGlass();
    }

    public void method_6270() {
        this.bat.setScreeching(false);
    }

    public boolean method_6266() {
        return this.bat.getScreechDuration() > 0;
    }

    private void applyEffect() {
        List players = this.bat.method_37908().method_8390(class_1657.class, this.bat.method_5829().method_1014(10.0), player -> true);
        for (class_1657 player2 : players) {
            if (this.isProtectedFromScreech(player2)) continue;
            player2.method_6092(new class_1293(ModEffects.DEAFEN, 250, 0));
        }
    }

    private boolean isProtectedFromScreech(class_1657 player) {
        player.method_31548();
        return ((class_1799)player.method_31548().field_7548.get(3)).method_31574(ModItems.SONIC_BLOCKERS);
    }

    private void crackGlass() {
        class_1937 world = this.bat.method_37908();
        class_2338 origin = new class_2338((int)this.bat.method_23317(), (int)this.bat.method_23318(), (int)this.bat.method_23321());
        int radius = 8;
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    class_2338 pos = origin.method_10069(x, y, z);
                    if (!world.method_8320(pos).method_27852(class_2246.field_10033) || !(this.bat.method_59922().method_43058() < 0.3)) continue;
                    world.method_8501(pos, ModBlocks.CRACKED_GLASS_BLOCK.method_9564());
                    world.method_8396(null, pos, class_3417.field_15081, class_3419.field_15245, 1.0f, 1.0f);
                }
            }
        }
    }

    private void spawnScreech() {
        class_1937 world = this.bat.method_37908();
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            class_1309 target = this.bat.method_5968();
            if (target != null) {
                class_243 targetPos = target.method_19538();
                class_243 source = this.bat.method_19538().method_1031(0.0, (double)1.6f, 0.0);
                class_243 offsetToTarget = targetPos.method_1020(source);
                class_243 normalized = offsetToTarget.method_1029();
                HashSet hitEntities = new HashSet();
                HashSet<class_1657> hitBlockerPlayers = new HashSet<class_1657>();
                int particleCount = (int)Math.floor(offsetToTarget.method_1033()) + 7;
                for (int i = 1; i <= particleCount; ++i) {
                    class_243 particlePos = source.method_1019(normalized.method_1021((double)i));
                    serverWorld.method_14199((class_2394)ModParticles.SCREECH, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
                    class_2338 blockPos = new class_2338((int)particlePos.field_1352, (int)particlePos.field_1351, (int)particlePos.field_1350);
                    class_238 hitBox = new class_238(blockPos).method_1014(2.0);
                    List entitiesHit = world.method_8390(class_1309.class, hitBox, entity -> entity != this.bat);
                    hitEntities.addAll(entitiesHit);
                    for (class_1297 hitEntity : hitEntities) {
                        class_1657 player;
                        if (hitEntity instanceof class_1657 && this.isProtectedFromScreech(player = (class_1657)hitEntity)) {
                            class_1799 helmet;
                            if (hitBlockerPlayers.contains(player) || (helmet = (class_1799)player.method_31548().field_7548.get(3)).method_7960() || !helmet.method_31574(ModItems.SONIC_BLOCKERS)) continue;
                            helmet.method_7970(1, (class_1309)player, class_1304.field_6169);
                            hitBlockerPlayers.add(player);
                            continue;
                        }
                        if (!(hitEntity instanceof class_1309)) continue;
                        class_1309 livingEntity = (class_1309)hitEntity;
                        livingEntity.method_5643(this.bat.method_48923().method_48812((class_1309)this.bat), 6.0f);
                    }
                }
            }
        }
    }
}

