/*
 * Decompiled with CFR 0.152.
 */
package net.domixcze.domixscreatures.entity.ai;

import java.util.EnumSet;
import java.util.Random;
import net.domixcze.domixscreatures.config.ModConfig;
import net.domixcze.domixscreatures.entity.ai.Sleepy;
import net.domixcze.domixscreatures.particle.ModParticles;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2902;
import net.minecraft.class_3218;

public class SleepGoal
extends class_1352 {
    private final Sleepy sleepyEntity;
    private final class_1308 entity;
    private int cooldown;
    private final int minCooldownTime;
    private final int maxCooldownTime;
    private final Random random = new Random();
    private final boolean sleepsDuringDay;
    private final boolean sleepsDuringNight;
    private final boolean wakesWithPlayerProximity;
    private final boolean wakesWithSneaking;
    private final double wakeUpRange;
    private final boolean wakesDuringThunder;
    private final boolean wakesDuringRain;
    private final boolean wakesWhenRainedOn;
    private final boolean wakesInWater;
    private final int particleInterval;
    private int particleTimer = 0;
    private final int maxHitsToWakeUp;
    private int hitCount = 0;

    public SleepGoal(Sleepy sleepyEntity, class_1308 entity, int particleInterval, boolean sleepsDuringDay, boolean sleepsDuringNight, boolean wakesWithPlayerProximity, boolean wakesWithSneaking, double wakeUpRange, int minCooldownTime, int maxCooldownTime, boolean wakesDuringThunder, boolean wakesDuringRain, boolean wakesWhenRainedOn, boolean wakesInWater, int maxHitsToWakeUp) {
        this.sleepyEntity = sleepyEntity;
        this.entity = entity;
        this.particleInterval = particleInterval;
        this.cooldown = this.getRandomCooldown();
        this.minCooldownTime = minCooldownTime;
        this.maxCooldownTime = maxCooldownTime;
        this.sleepsDuringDay = sleepsDuringDay;
        this.sleepsDuringNight = sleepsDuringNight;
        this.wakesWithPlayerProximity = wakesWithPlayerProximity;
        this.wakesWithSneaking = wakesWithSneaking;
        this.wakeUpRange = wakeUpRange;
        this.wakesDuringThunder = wakesDuringThunder;
        this.wakesDuringRain = wakesDuringRain;
        this.wakesWhenRainedOn = wakesWhenRainedOn;
        this.wakesInWater = wakesInWater;
        this.maxHitsToWakeUp = Math.min(maxHitsToWakeUp, 5);
        ServerLivingEntityEvents.AFTER_DAMAGE.register(this::handleDamage);
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    private int getRandomCooldown() {
        return this.random.nextInt(this.maxCooldownTime - this.minCooldownTime + 1) + this.minCooldownTime;
    }

    public boolean method_6264() {
        class_1657 nearestPlayer;
        boolean shouldSleep = false;
        if (this.sleepsDuringDay && this.entity.method_37908().method_8530()) {
            shouldSleep = true;
        } else if (this.sleepsDuringNight && this.entity.method_37908().method_23886()) {
            shouldSleep = true;
        }
        if (this.wakesWithPlayerProximity && (nearestPlayer = this.entity.method_37908().method_18460((class_1297)this.entity, this.wakeUpRange)) != null) {
            boolean playerSneaking = nearestPlayer.method_5715();
            shouldSleep = !this.wakesWithSneaking && playerSneaking;
        }
        if (this.wakesInWater && this.entity.method_5799()) {
            shouldSleep = false;
        }
        if (this.wakesDuringThunder && this.entity.method_37908().method_8546()) {
            shouldSleep = false;
        }
        if (this.wakesDuringRain && this.entity.method_37908().method_8419()) {
            shouldSleep = false;
        }
        if (this.wakesWhenRainedOn && this.isBeingRainedOn()) {
            shouldSleep = false;
        }
        if (shouldSleep) {
            if (this.cooldown > 0) {
                --this.cooldown;
            }
            return this.cooldown <= 0;
        }
        this.cooldown = this.getRandomCooldown();
        return false;
    }

    public void method_6269() {
        this.sleepyEntity.setSleeping(true);
    }

    public void method_6268() {
        super.method_6268();
        if (this.entity.method_6113()) {
            this.entity.method_5942().method_6340();
            this.entity.method_5988().method_6231();
            if (ModConfig.INSTANCE.enableSleepParticles && this.particleInterval > 0) {
                ++this.particleTimer;
                if (this.particleTimer >= this.particleInterval) {
                    this.particleTimer = 0;
                    this.spawnSleepParticle();
                }
            }
        } else {
            this.particleTimer = 0;
        }
    }

    public void method_6270() {
        this.sleepyEntity.setSleeping(false);
        this.cooldown = this.getRandomCooldown();
    }

    public boolean method_6266() {
        return this.method_6264();
    }

    private boolean isBeingRainedOn() {
        class_2338 blockPos = this.entity.method_24515();
        return this.entity.method_37908().method_8419() && (this.hasRain(blockPos) || this.hasRain(class_2338.method_49637((double)blockPos.method_10263(), (double)this.entity.method_5829().field_1325, (double)blockPos.method_10260())));
    }

    private boolean hasRain(class_2338 pos) {
        if (!this.entity.method_37908().method_8419()) {
            return false;
        }
        if (!this.entity.method_37908().method_8311(pos)) {
            return false;
        }
        if (this.entity.method_37908().method_8598(class_2902.class_2903.field_13197, pos).method_10264() > pos.method_10264()) {
            return false;
        }
        class_1959 biome = (class_1959)this.entity.method_37908().method_23753(pos).comp_349();
        return biome.method_48162(pos) == class_1959.class_1963.field_9382;
    }

    class_243 getHeadPositionWithLookVec(class_1308 entity) {
        class_243 eyePos = entity.method_19538().method_1031(0.0, (double)entity.method_5751() + 0.1, 0.0);
        class_243 lookVec = entity.method_5828(1.0f).method_1029().method_1021(0.4);
        return eyePos.method_1019(lookVec);
    }

    private void spawnSleepParticle() {
        class_1937 class_19372 = this.entity.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            class_243 headPos = this.getHeadPositionWithLookVec(this.entity);
            serverWorld.method_14199((class_2394)ModParticles.SLEEP, headPos.field_1352, headPos.field_1351, headPos.field_1350, 2, 0.1, 0.05, 0.1, 0.0);
        }
    }

    private void handleDamage(class_1309 entity, class_1282 source, float baseDamage, float takenDamage, boolean blocked) {
        if (entity == this.entity && this.sleepyEntity.method_6113()) {
            ++this.hitCount;
            if (this.hitCount >= this.maxHitsToWakeUp) {
                this.method_6270();
                this.hitCount = 0;
            }
        }
    }
}

