/*
 * Decompiled with CFR 0.152.
 */
package net.domixcze.domixscreatures.entity.custom;

import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import net.domixcze.domixscreatures.entity.ModEntities;
import net.domixcze.domixscreatures.entity.ai.BabyFollowParentGoal;
import net.domixcze.domixscreatures.entity.ai.BoarMeleeAttackGoal;
import net.domixcze.domixscreatures.entity.ai.ProtectBabiesGoal;
import net.domixcze.domixscreatures.entity.ai.SleepGoal;
import net.domixcze.domixscreatures.entity.ai.Sleepy;
import net.domixcze.domixscreatures.entity.ai.SnowLayerable;
import net.domixcze.domixscreatures.util.ModTags;
import net.domixcze.domixscreatures.util.SnowLayerUtil;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1429;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BoarEntity
extends class_1429
implements GeoEntity,
Sleepy,
SnowLayerable {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final class_2940<Boolean> HAS_SNOW_LAYER = class_2945.method_12791(BoarEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> IS_DIGGING = class_2945.method_12791(BoarEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> SLEEPING = class_2945.method_12791(BoarEntity.class, (class_2941)class_2943.field_13323);
    private int snowTicks = 0;
    private int snowMeltTimer = 0;
    private int diggingCooldown = 0;
    private final int MAX_DIGGING_COOLDOWN = 6000;
    private int diggingTimer = 0;
    private final int MAX_DIGGING_TIMER = 200;

    public BoarEntity(class_1299<? extends class_1429> entityType, class_1937 world) {
        super(entityType, world);
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1429.method_26828().method_26868(class_5134.field_23716, 30.0).method_26868(class_5134.field_23719, 0.2).method_26868(class_5134.field_23721, 3.0);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new SleepGoal(this, (class_1308)this, 100, true, false, true, false, 5.0, 500, 700, true, false, true, true, 2));
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new BoarMeleeAttackGoal(this, 1.0, true));
        this.field_6201.method_6277(2, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new BoarDigGoal(this));
        this.field_6201.method_6277(4, (class_1352)new BabyFollowParentGoal(this, 1.0));
        this.field_6201.method_6277(5, (class_1352)new class_1394((class_1314)this, 0.75, 1.0f));
        this.field_6201.method_6277(6, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, new ProtectBabiesGoal<BoarEntity>(this, BoarEntity.class, 8.0));
        this.field_6185.method_6277(2, (class_1352)new class_1399((class_1314)this, new Class[0]));
    }

    public boolean method_5931() {
        return !this.method_6113();
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(HAS_SNOW_LAYER, (Object)false);
        builder.method_56912(IS_DIGGING, (Object)false);
        builder.method_56912(SLEEPING, (Object)false);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("IsDigging", this.isDigging());
        nbt.method_10569("DiggingCooldown", this.diggingCooldown);
        nbt.method_10569("DiggingTimer", this.diggingTimer);
        nbt.method_10556("Sleeping", this.method_6113());
        nbt.method_10556("HasSnowLayer", this.hasSnowLayer());
        nbt.method_10569("SnowTicks", this.snowTicks);
        nbt.method_10569("SnowMeltTimer", this.snowMeltTimer);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setHasSnowLayer(nbt.method_10577("HasSnowLayer"));
        this.snowTicks = nbt.method_10550("SnowTicks");
        this.snowMeltTimer = nbt.method_10550("SnowMeltTimer");
        this.setDigging(nbt.method_10577("IsDigging"));
        this.diggingCooldown = nbt.method_10550("DiggingCooldown");
        this.diggingTimer = nbt.method_10550("DiggingTimer");
        this.setSleeping(nbt.method_10577("Sleeping"));
    }

    @Override
    public boolean hasSnowLayer() {
        return (Boolean)this.field_6011.method_12789(HAS_SNOW_LAYER);
    }

    @Override
    public void setHasSnowLayer(boolean hasSnow) {
        this.field_6011.method_12778(HAS_SNOW_LAYER, (Object)hasSnow);
    }

    @Override
    public int getSnowTicks() {
        return this.snowTicks;
    }

    @Override
    public void setSnowTicks(int ticks) {
        this.snowTicks = ticks;
    }

    @Override
    public int getSnowMeltTimer() {
        return this.snowMeltTimer;
    }

    @Override
    public void setSnowMeltTimer(int timer) {
        this.snowMeltTimer = timer;
    }

    @Override
    public boolean method_6113() {
        return (Boolean)this.field_6011.method_12789(SLEEPING);
    }

    @Override
    public void setSleeping(boolean sleeping) {
        this.field_6011.method_12778(SLEEPING, (Object)sleeping);
        if (sleeping) {
            this.method_5942().method_6340();
        }
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (itemStack.method_31574(class_1802.field_42716) && this.hasSnowLayer()) {
            if (!this.method_37908().field_9236) {
                this.setHasSnowLayer(false);
                this.snowMeltTimer = 0;
                int count = 3 + this.method_37908().field_9229.method_43048(2);
                this.method_5775(new class_1799((class_1935)class_1802.field_8543, count));
            }
            SnowLayerUtil.spawnSnowParticles((class_1309)this);
            this.method_5783(class_3417.field_15165, 1.0f, 1.0f);
            if (!player.method_7337()) {
                itemStack.method_7970(1, (class_1309)player, class_1304.field_6173);
            }
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    protected class_4048 method_55694(class_4050 pose) {
        if (this.method_6109()) {
            return class_4048.method_18385((float)0.5f, (float)0.5f);
        }
        return this.method_5864().method_18386();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController landController = new AnimationController((GeoAnimatable)this, "land_controller", 5, this::landPredicate);
        landController.triggerableAnim("attack", RawAnimation.begin().then("animation.boar.attack", Animation.LoopType.PLAY_ONCE));
        controllers.add(landController);
        controllers.add(new AnimationController((GeoAnimatable)this, "water_controller", 5, this::waterPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "sleep_controller", 5, this::sleepPredicate));
    }

    private <P extends GeoAnimatable> PlayState landPredicate(AnimationState<P> state) {
        if (this.method_5799()) {
            return PlayState.STOP;
        }
        if (this.method_6109()) {
            if (this.method_18798().method_37268() > 1.0E-9) {
                state.getController().setAnimation(RawAnimation.begin().then("animation.baby_boar.walk", Animation.LoopType.LOOP));
            } else {
                state.getController().setAnimation(RawAnimation.begin().then("animation.baby_boar.idle", Animation.LoopType.LOOP));
            }
        } else if (this.isDigging()) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.boar.dig", Animation.LoopType.LOOP));
        } else if (this.method_18798().method_37268() > 1.0E-9) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.boar.walk", Animation.LoopType.LOOP));
        } else {
            state.getController().setAnimation(RawAnimation.begin().then("animation.boar.idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState waterPredicate(AnimationState<T> state) {
        if (!this.method_5799()) {
            return PlayState.STOP;
        }
        if (this.method_6109()) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.baby_boar.swim", Animation.LoopType.LOOP));
        } else {
            state.getController().setAnimation(RawAnimation.begin().then("animation.boar.swim", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState sleepPredicate(AnimationState<T> state) {
        if (this.method_6113()) {
            if (this.method_6109()) {
                state.getController().setAnimation(RawAnimation.begin().then("animation.baby_boar.sleep", Animation.LoopType.LOOP));
            } else {
                state.getController().setAnimation(RawAnimation.begin().then("animation.boar.sleep", Animation.LoopType.LOOP));
            }
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return (class_1296)ModEntities.BOAR.method_5883((class_1937)world);
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_31573(ModTags.Items.BOAR_FOR_BREEDING);
    }

    public boolean isDigging() {
        return (Boolean)this.field_6011.method_12789(IS_DIGGING);
    }

    public void setDigging(boolean isDigging) {
        this.field_6011.method_12778(IS_DIGGING, (Object)isDigging);
    }

    public void method_5773() {
        super.method_5773();
        SnowLayerUtil.handleSnowLayerTick((class_1309)this, this);
        if (!this.method_37908().field_9236) {
            if (!this.isDigging() && this.diggingCooldown > 0) {
                --this.diggingCooldown;
            }
            if (this.isDigging()) {
                ++this.diggingTimer;
                if (this.diggingTimer >= 200) {
                    this.setDigging(false);
                    this.diggingCooldown = 6000;
                    this.diggingTimer = 0;
                    this.digAndDrop(this.method_37908(), this.method_24515().method_10074(), this.method_59922());
                }
            } else if (this.diggingTimer > 0) {
                this.diggingTimer = 0;
            }
        }
    }

    private void digAndDrop(class_1937 world, class_2338 pos, class_5819 random) {
        world.method_8501(pos, class_2246.field_10566.method_9564());
        if (!world.method_8608() && random.method_43057() <= 0.3f) {
            Optional<class_1792> droppedItem = this.getRandomItemFromTag(random, ModTags.Items.DROPS_FROM_BOAR_DIGGING);
            droppedItem.ifPresent(item -> {
                class_1799 stack = new class_1799((class_1935)item);
                world.method_8649((class_1297)new class_1542(world, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, stack));
            });
        }
    }

    private Optional<class_1792> getRandomItemFromTag(class_5819 random, class_6862<class_1792> tag) {
        List<class_1792> items = this.method_37908().method_30349().method_30530(class_7924.field_41197).method_10220().filter(item -> item.method_7854().method_31573(tag)).toList();
        if (items.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(items.get(random.method_43048(items.size())));
    }

    public float method_6017() {
        return 0.7f;
    }

    protected class_3414 method_5994() {
        if (this.method_6113()) {
            return null;
        }
        return class_3417.field_14615;
    }

    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_14750;
    }

    protected class_3414 method_6002() {
        return class_3417.field_14689;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(class_3417.field_14894, 0.15f, 1.0f);
    }

    public static class BoarDigGoal
    extends class_1352 {
        private final BoarEntity boar;
        private int soundCooldown = 10;
        private class_2338 digPos;

        public BoarDigGoal(BoarEntity boar) {
            this.boar = boar;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            if (this.boar.diggingCooldown > 0) {
                return false;
            }
            if (this.boar.method_6109()) {
                return false;
            }
            if (this.boar.method_6113()) {
                return false;
            }
            class_2338 pos = this.boar.method_24515().method_10074();
            class_2680 state = this.boar.method_37908().method_8320(pos);
            return this.boar.method_37908().method_23753(this.boar.method_24515()).method_40220(ModTags.Biomes.BOAR_CAN_DIG_IN) && (state.method_27852(class_2246.field_10219) || state.method_27852(class_2246.field_10520));
        }

        public void method_6269() {
            this.boar.setDigging(true);
            this.boar.method_5942().method_6340();
            this.digPos = this.boar.method_24515().method_10074();
        }

        public void method_6270() {
            this.boar.setDigging(false);
            this.boar.diggingCooldown = 6000;
        }

        public boolean method_6266() {
            class_2338 pos = this.boar.method_24515().method_10074();
            class_2680 state = this.boar.method_37908().method_8320(pos);
            if (!this.boar.method_37908().method_23753(this.boar.method_24515()).method_40220(ModTags.Biomes.BOAR_CAN_DIG_IN) || !state.method_27852(class_2246.field_10219) && !state.method_27852(class_2246.field_10520)) {
                return false;
            }
            if (this.boar.method_6113()) {
                return false;
            }
            if (!this.digPos.equals((Object)this.boar.method_24515().method_10074())) {
                return false;
            }
            return this.boar.isDigging();
        }

        public void method_6268() {
            this.boar.method_5942().method_6340();
            this.boar.method_5988().method_6231();
            if (this.boar.isDigging()) {
                this.spawnDiggingParticles(this.boar);
                if (this.soundCooldown <= 0) {
                    this.boar.method_37908().method_43128(null, this.boar.method_23317(), this.boar.method_23318(), this.boar.method_23321(), class_3417.field_14798, this.boar.method_5634(), 1.0f, 1.0f);
                    this.soundCooldown = 10;
                } else {
                    --this.soundCooldown;
                }
            }
        }

        private void spawnDiggingParticles(BoarEntity boar) {
            class_1937 class_19372 = boar.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 serverWorld = (class_3218)class_19372;
                double centerX = boar.method_23317();
                double centerY = boar.method_23318();
                double centerZ = boar.method_23321();
                class_2388 dirtParticleEffect = new class_2388(class_2398.field_11217, class_2246.field_10566.method_9564());
                class_243 headVec = boar.method_5828(0.0f);
                double particleX = centerX + headVec.field_1352;
                double particleZ = centerZ + headVec.field_1350;
                for (int i = 0; i < 5; ++i) {
                    double offsetX = (boar.method_59922().method_43058() - 0.5) * 0.5;
                    double offsetZ = (boar.method_59922().method_43058() - 0.5) * 0.5;
                    serverWorld.method_14199((class_2394)dirtParticleEffect, particleX + offsetX, centerY, particleZ + offsetZ, 1, 0.0, 0.0, 0.0, 0.1);
                }
            }
        }
    }
}

