/*
 * Decompiled with CFR 0.152.
 */
package net.domixcze.domixscreatures.entity.custom;

import net.domixcze.domixscreatures.entity.ModEntities;
import net.domixcze.domixscreatures.entity.ai.BabyFollowParentGoal;
import net.domixcze.domixscreatures.entity.ai.SleepGoal;
import net.domixcze.domixscreatures.entity.ai.Sleepy;
import net.domixcze.domixscreatures.entity.ai.SnowLayerable;
import net.domixcze.domixscreatures.entity.client.deer.DeerAntlerSize;
import net.domixcze.domixscreatures.entity.client.deer.DeerVariants;
import net.domixcze.domixscreatures.util.ModTags;
import net.domixcze.domixscreatures.util.SnowLayerUtil;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1338;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DeerEntity
extends class_1429
implements GeoEntity,
Sleepy,
SnowLayerable {
    private final AnimatableInstanceCache geocache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int snowTicks = 0;
    private int snowMeltTimer = 0;
    public static final class_2940<Boolean> HAS_SNOW_LAYER = class_2945.method_12791(DeerEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> VARIANT = class_2945.method_12791(DeerEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> ANTLER_SIZE = class_2945.method_12791(DeerEntity.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Boolean> SLEEPING = class_2945.method_12791(DeerEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> IS_RUNNING = class_2945.method_12791(DeerEntity.class, (class_2941)class_2943.field_13323);
    private static final class_4048 BABY_DIMENSIONS = class_4048.method_18385((float)0.6f, (float)1.2f);
    private static final class_4048 ADULT_DIMENSIONS = class_4048.method_18385((float)0.8f, (float)1.5f);
    private static final class_4048 SLEEPING_BABY_DIMENSIONS = class_4048.method_18385((float)0.6f, (float)0.6f);
    private static final class_4048 SLEEPING_ADULT_DIMENSIONS = class_4048.method_18385((float)0.8f, (float)0.8f);
    private static final double MOB_RUNNING_VELOCITY_THRESHOLD = 0.0025000000000000005;

    public DeerEntity(class_1299<? extends class_1429> entityType, class_1937 world) {
        super(entityType, world);
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1429.method_26828().method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23719, (double)0.2f);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new SleepGoal(this, (class_1308)this, 100, true, false, true, true, 7.0, 500, 700, true, false, true, true, 1));
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(2, new FleeGoal<class_1309>(this, class_1309.class, ModTags.EntityTypes.DEER_FLEE_FROM, 10.0f, 1.0, 1.5));
        this.field_6201.method_6277(3, (class_1352)new BabyFollowParentGoal(this, 1.25));
        this.field_6201.method_6277(4, (class_1352)new class_1394((class_1314)this, 0.75, 1.0f));
        this.field_6201.method_6277(4, (class_1352)new class_1376((class_1308)this));
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(HAS_SNOW_LAYER, (Object)false);
        builder.method_56912(VARIANT, (Object)DeerVariants.BROWN.ordinal());
        builder.method_56912(ANTLER_SIZE, (Object)DeerAntlerSize.NONE.ordinal());
        builder.method_56912(SLEEPING, (Object)false);
        builder.method_56912(IS_RUNNING, (Object)false);
    }

    public boolean method_5931() {
        return !this.method_6113();
    }

    public boolean isRunning() {
        return (Boolean)this.field_6011.method_12789(IS_RUNNING);
    }

    public void setRunning(boolean running) {
        this.field_6011.method_12778(IS_RUNNING, (Object)running);
    }

    @Override
    public boolean method_6113() {
        return (Boolean)this.field_6011.method_12789(SLEEPING);
    }

    @Override
    public void setSleeping(boolean sleeping) {
        this.field_6011.method_12778(SLEEPING, (Object)sleeping);
        if (sleeping) {
            this.method_5942().method_6340();
        }
    }

    public DeerVariants getVariant() {
        return DeerVariants.values()[(Integer)this.field_6011.method_12789(VARIANT)];
    }

    public void setVariant(DeerVariants variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant.ordinal());
    }

    public DeerAntlerSize getAntlerSize() {
        return DeerAntlerSize.values()[(Integer)this.field_6011.method_12789(ANTLER_SIZE)];
    }

    public void setAntlerSize(DeerAntlerSize size) {
        this.field_6011.method_12778(ANTLER_SIZE, (Object)size.ordinal());
    }

    public void method_5773() {
        super.method_5773();
        SnowLayerUtil.handleSnowLayerTick((class_1309)this, this);
        if (!this.method_37908().method_8608()) {
            boolean currentlyMovingFast;
            boolean bl = currentlyMovingFast = this.method_18798().method_37268() > 0.0025000000000000005;
            if (this.isRunning() != currentlyMovingFast) {
                this.setRunning(currentlyMovingFast);
            }
        }
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        entityData = super.method_5943(world, difficulty, spawnReason, entityData);
        if (world.method_8409().method_43058() < 0.05) {
            this.setVariant(DeerVariants.ALBINO);
        } else {
            this.setVariant(DeerVariants.BROWN);
        }
        if (!this.method_6109()) {
            if (world.method_8409().method_43057() < 0.2f) {
                this.setAntlerSize(DeerAntlerSize.SMALL);
            } else if (world.method_8409().method_43057() < 0.1f) {
                this.setAntlerSize(DeerAntlerSize.MEDIUM);
            } else if (world.method_8409().method_43057() < 0.05f) {
                this.setAntlerSize(DeerAntlerSize.LARGE);
            } else {
                this.setAntlerSize(DeerAntlerSize.NONE);
            }
        }
        return entityData;
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (itemStack.method_31574(class_1802.field_42716) && this.hasSnowLayer()) {
            if (!this.method_37908().field_9236) {
                this.setHasSnowLayer(false);
                this.snowMeltTimer = 0;
                int count = 3 + this.method_37908().field_9229.method_43048(2);
                this.method_5775(new class_1799((class_1935)class_1802.field_8543, count));
            }
            SnowLayerUtil.spawnSnowParticles((class_1309)this);
            this.method_5783(class_3417.field_15165, 1.0f, 1.0f);
            if (!player.method_7337()) {
                itemStack.method_7970(1, (class_1309)player, class_1304.field_6173);
            }
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    public void method_5674(class_2940<?> data) {
        if (SLEEPING.equals(data)) {
            this.method_18382();
        }
        super.method_5674(data);
    }

    public class_4048 method_55694(class_4050 pose) {
        return this.getCustomDimensions(pose);
    }

    private class_4048 getCustomDimensions(class_4050 pose) {
        if (this.method_6113()) {
            return this.method_6109() ? SLEEPING_BABY_DIMENSIONS : SLEEPING_ADULT_DIMENSIONS;
        }
        return this.method_6109() ? BABY_DIMENSIONS : ADULT_DIMENSIONS;
    }

    protected void method_5619() {
        super.method_5619();
        if (!this.method_37908().method_8608()) {
            class_5819 random = this.field_5974;
            if (random.method_43057() < 0.2f) {
                this.setAntlerSize(DeerAntlerSize.SMALL);
            } else if (random.method_43057() < 0.1f) {
                this.setAntlerSize(DeerAntlerSize.MEDIUM);
            } else if (random.method_43057() < 0.05f) {
                this.setAntlerSize(DeerAntlerSize.LARGE);
            } else {
                this.setAntlerSize(DeerAntlerSize.NONE);
            }
        }
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        DeerEntity baby = (DeerEntity)ModEntities.DEER.method_5883((class_1937)world);
        if (baby != null) {
            DeerEntity parent1 = this;
            DeerEntity parent2 = (DeerEntity)entity;
            if (parent1.getVariant() == DeerVariants.ALBINO && parent2.getVariant() == DeerVariants.ALBINO) {
                baby.setVariant(DeerVariants.ALBINO);
            } else if (parent1.getVariant() == DeerVariants.ALBINO || parent2.getVariant() == DeerVariants.ALBINO) {
                double chance = 0.25;
                if (world.method_8409().method_43058() < chance) {
                    baby.setVariant(DeerVariants.ALBINO);
                } else {
                    baby.setVariant(DeerVariants.BROWN);
                }
            } else {
                double chance = 0.01;
                if (world.method_8409().method_43058() < chance) {
                    baby.setVariant(DeerVariants.ALBINO);
                } else {
                    baby.setVariant(DeerVariants.BROWN);
                }
            }
            baby.setAntlerSize(DeerAntlerSize.NONE);
        }
        return baby;
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_31573(ModTags.Items.DEER_FOR_BREEDING);
    }

    public boolean method_6474(class_1429 other) {
        if (other == this) {
            return false;
        }
        if (!(other instanceof DeerEntity)) {
            return false;
        }
        DeerEntity otherDeer = (DeerEntity)other;
        boolean thisHasAntlers = this.getAntlerSize() != DeerAntlerSize.NONE;
        boolean otherHasAntlers = otherDeer.getAntlerSize() != DeerAntlerSize.NONE;
        return this.method_6479() && other.method_6479() && thisHasAntlers ^ otherHasAntlers;
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("HasSnowLayer", this.hasSnowLayer());
        nbt.method_10569("SnowTicks", this.snowTicks);
        nbt.method_10569("SnowMeltTimer", this.snowMeltTimer);
        nbt.method_10556("Sleeping", this.method_6113());
        nbt.method_10569("Variant", this.getVariant().ordinal());
        nbt.method_10569("AntlerSize", this.getAntlerSize().ordinal());
        nbt.method_10556("IsRunning", this.isRunning());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setHasSnowLayer(nbt.method_10577("HasSnowLayer"));
        this.snowTicks = nbt.method_10550("SnowTicks");
        this.snowMeltTimer = nbt.method_10550("SnowMeltTimer");
        this.setSleeping(nbt.method_10577("Sleeping"));
        this.setVariant(DeerVariants.values()[nbt.method_10550("Variant")]);
        this.setAntlerSize(DeerAntlerSize.values()[nbt.method_10550("AntlerSize")]);
        this.setRunning(nbt.method_10577("IsRunning"));
    }

    @Override
    public boolean hasSnowLayer() {
        return (Boolean)this.field_6011.method_12789(HAS_SNOW_LAYER);
    }

    @Override
    public void setHasSnowLayer(boolean hasSnow) {
        this.field_6011.method_12778(HAS_SNOW_LAYER, (Object)hasSnow);
    }

    @Override
    public int getSnowTicks() {
        return this.snowTicks;
    }

    @Override
    public void setSnowTicks(int ticks) {
        this.snowTicks = ticks;
    }

    @Override
    public int getSnowMeltTimer() {
        return this.snowMeltTimer;
    }

    @Override
    public void setSnowMeltTimer(int timer) {
        this.snowMeltTimer = timer;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "land_controller", 5, this::landPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "water_controller", 5, this::waterPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "sleep_controller", 5, this::sleepPredicate));
    }

    private <T extends GeoAnimatable> PlayState landPredicate(AnimationState<T> state) {
        if (this.method_5799()) {
            return PlayState.STOP;
        }
        if (this.method_6109()) {
            if (this.method_18798().method_37268() > 1.0E-9) {
                state.getController().setAnimation(RawAnimation.begin().then("animation.baby_deer.walk", Animation.LoopType.LOOP));
            } else {
                state.getController().setAnimation(RawAnimation.begin().then("animation.baby_deer.idle", Animation.LoopType.LOOP));
            }
        } else if (this.isRunning()) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.deer.run", Animation.LoopType.LOOP));
        } else if (this.method_18798().method_37268() > 1.0E-9) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.deer.walk", Animation.LoopType.LOOP));
        } else {
            state.getController().setAnimation(RawAnimation.begin().then("animation.deer.idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState waterPredicate(AnimationState<T> state) {
        if (!this.method_5799()) {
            return PlayState.STOP;
        }
        if (this.method_6109()) {
            if (this.method_5799()) {
                state.getController().setAnimation(RawAnimation.begin().then("animation.baby_deer.swim", Animation.LoopType.LOOP));
            }
        } else if (this.method_5799()) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.deer.swim", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState sleepPredicate(AnimationState<T> state) {
        if (this.method_6113()) {
            if (this.method_6109()) {
                state.getController().setAnimation(RawAnimation.begin().then("animation.baby_deer.sleep", Animation.LoopType.LOOP));
            } else {
                state.getController().setAnimation(RawAnimation.begin().then("animation.deer.sleep", Animation.LoopType.LOOP));
            }
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geocache;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(class_3417.field_14613, 0.15f, 1.0f);
    }

    static class FleeGoal<T extends class_1309>
    extends class_1338<T> {
        private final DeerEntity deer;

        public FleeGoal(DeerEntity deer, Class<T> fleeFromType, class_6862<class_1299<?>> fleeFromTag, float distance, double slowSpeed, double fastSpeed) {
            super((class_1314)deer, fleeFromType, distance, slowSpeed, fastSpeed, targetEntity -> {
                boolean isInTag = targetEntity != null && targetEntity.method_5864().method_20210(fleeFromTag);
                boolean passesDefaultChecks = class_1301.field_6156.test(targetEntity);
                return isInTag && passesDefaultChecks;
            });
            this.deer = deer;
        }

        public boolean method_6264() {
            return !this.deer.method_6113() && super.method_6264();
        }

        public boolean method_6266() {
            return !this.deer.method_6113() && super.method_6266();
        }

        public void method_6269() {
            super.method_6269();
            this.deer.setRunning(true);
        }

        public void method_6270() {
            super.method_6270();
            this.deer.setRunning(false);
        }
    }
}

