/*
 * Decompiled with CFR 0.152.
 */
package net.domixcze.domixscreatures.entity.custom;

import net.domixcze.domixscreatures.entity.ai.Beachable;
import net.domixcze.domixscreatures.entity.ai.BeachedGoal;
import net.domixcze.domixscreatures.entity.ai.EelMeleeAttackGoal;
import net.domixcze.domixscreatures.entity.client.eel.EelVariants;
import net.domixcze.domixscreatures.util.ModTags;
import net.minecraft.class_1266;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1332;
import net.minecraft.class_1352;
import net.minecraft.class_1376;
import net.minecraft.class_1378;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1408;
import net.minecraft.class_1412;
import net.minecraft.class_1431;
import net.minecraft.class_1462;
import net.minecraft.class_1480;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5757;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class EelEntity
extends class_1480
implements GeoEntity,
Beachable {
    private final AnimatableInstanceCache geocache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final class_2940<Integer> VARIANT = class_2945.method_12791(EelEntity.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Boolean> CHARGED = class_2945.method_12791(EelEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> BEACHED = class_2945.method_12791(EelEntity.class, (class_2941)class_2943.field_13323);
    private int particleCooldown = 0;
    public int attackCooldown;
    public static final int ATTACK_COOLDOWN = 1000;

    public EelEntity(class_1299<? extends class_1480> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6207 = new class_5757((class_1308)this, 70, 5, 0.01f, 0.05f, true);
        this.field_6206 = new class_1332((class_1308)this, 8);
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1480.method_26828().method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23721, 0.5).method_26868(class_5134.field_23719, 2.0);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new BeachedGoal(this, (class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new EelMeleeAttackGoal(this, 1.0, true));
        this.field_6201.method_6277(2, (class_1352)new class_1378((class_1314)this, 0.8, 12));
        this.field_6201.method_6277(3, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1462.class, true));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1431.class, true));
        this.field_6185.method_6277(2, (class_1352)new class_1399((class_1314)this, new Class[0]));
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        entityData = super.method_5943(world, difficulty, spawnReason, entityData);
        this.setAttackCooldown(1000);
        if (spawnReason == class_3730.field_16459 || spawnReason == class_3730.field_16462 || spawnReason == class_3730.field_16465 || spawnReason == class_3730.field_16472) {
            class_6880 biomeEntry = world.method_23753(this.method_24515());
            if (biomeEntry.method_40220(ModTags.Biomes.SPAWNS_YELLOW_EEL)) {
                this.setVariant(this.field_5974.method_43056() ? EelVariants.YELLOW : EelVariants.GREEN);
            } else if (biomeEntry.method_40220(ModTags.Biomes.SPAWNS_ABYSS_EEL)) {
                this.setVariant(this.field_5974.method_43057() < 0.1f ? EelVariants.ABYSS : EelVariants.GREEN);
            } else {
                this.setVariant(EelVariants.GREEN);
            }
        }
        return entityData;
    }

    public EelVariants getVariant() {
        return EelVariants.values()[(Integer)this.field_6011.method_12789(VARIANT)];
    }

    public void setVariant(EelVariants variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant.ordinal());
    }

    public void method_5773() {
        super.method_5773();
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
            if (this.attackCooldown <= 0) {
                this.setCharged(true);
            }
        }
        if (this.isCharged() && this.method_37908().field_9236) {
            if (this.particleCooldown <= 0) {
                this.spawnElectricParticles();
                this.particleCooldown = 5;
            } else {
                --this.particleCooldown;
            }
        }
    }

    private void spawnElectricParticles() {
        for (int i = 0; i < 2; ++i) {
            double offsetX = this.field_5974.method_43058() * 0.7 - 0.35;
            double offsetY = this.field_5974.method_43058() * 0.3 + 0.2;
            double offsetZ = this.field_5974.method_43058() * 0.7 - 0.35;
            this.method_37908().method_8406((class_2394)class_2398.field_29644, this.method_23317() + offsetX, this.method_23318() + offsetY, this.method_23321() + offsetZ, 0.0, 0.0, 0.0);
        }
    }

    protected class_1408 method_5965(class_1937 world) {
        return new class_1412((class_1308)this, world);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(VARIANT, (Object)EelVariants.GREEN.ordinal());
        builder.method_56912(CHARGED, (Object)false);
        builder.method_56912(BEACHED, (Object)false);
    }

    @Override
    public boolean isBeached() {
        return (Boolean)this.field_6011.method_12789(BEACHED);
    }

    @Override
    public void setBeached(boolean beached) {
        this.field_6011.method_12778(BEACHED, (Object)beached);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("Variant", this.getVariant().ordinal());
        nbt.method_10556("Charged", this.isCharged());
        nbt.method_10569("AttackCooldown", this.attackCooldown);
        nbt.method_10556("Beached", this.isBeached());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setVariant(EelVariants.values()[nbt.method_10550("Variant")]);
        this.setBeached(nbt.method_10577("Beached"));
        this.setCharged(nbt.method_10577("Charged"));
        if (nbt.method_10545("AttackCooldown")) {
            this.attackCooldown = nbt.method_10550("AttackCooldown");
        } else {
            this.setAttackCooldown(1000);
        }
    }

    public int getAttackCooldown() {
        return this.attackCooldown;
    }

    public void setAttackCooldown(int attackCooldown) {
        this.attackCooldown = attackCooldown;
        if (attackCooldown > 0) {
            this.setCharged(false);
        }
    }

    public boolean isCharged() {
        return (Boolean)this.field_6011.method_12789(CHARGED);
    }

    public void setCharged(boolean charged) {
        this.field_6011.method_12778(CHARGED, (Object)charged);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate));
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> state) {
        if (this.method_18798().method_37268() > 1.0E-9) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.eel.swim", Animation.LoopType.LOOP));
        } else if (this.isBeached()) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.eel.beached", Animation.LoopType.HOLD_ON_LAST_FRAME));
        } else {
            state.getController().setAnimation(RawAnimation.begin().then("animation.eel.idle_swim", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geocache;
    }
}

